%define _unpackaged_files_terminate_build 1
%define pypi_name libarchive-c
%define mod_name libarchive

%def_with check

Name: python3-module-%pypi_name
Version: 5.3
Release: alt1
Summary: Python interface to libarchive
License: CC0
Group: Development/Python3
Url: https://pypi.org/project/libarchive-c/
Vcs: https://github.com/Changaco/python-libarchive-c
Source: %name-%version.tar
Source1: %pyproject_deps_config_name
Patch1: %name-%version-alt.patch
Requires: libarchive
%pyproject_runtimedeps_metadata
BuildRequires(pre): rpm-build-pyproject
%pyproject_builddeps_build
%if_with check
%pyproject_builddeps_metadata
%pyproject_builddeps_check
%endif
BuildRequires: libarchive-devel

%description
The libarchive library provides a flexible interface for reading and writing
archives in various formats such as tar and cpio. libarchive also supports
reading and writing archives compressed using various compression filters such
as gzip and bzip2.
A Python interface to libarchive. It uses the standard ctypes module to
dynamically load and access the C library.

%prep
%setup
%patch1 -p1
%pyproject_scm_init
%pyproject_deps_resync_build
%pyproject_deps_resync_metadata
%if_with check
%pyproject_deps_resync_check_tox tox.ini testenv
%endif

%build
%pyproject_build

%install
%pyproject_install

# pure Python package depends on libarchive
%if "%python3_sitelibdir_noarch" != "%python3_sitelibdir"
install -d %buildroot%python3_sitelibdir
mv %buildroot%python3_sitelibdir_noarch/* %buildroot%python3_sitelibdir/
%endif

%check
%pyproject_run_pytest -ra -Wignore

%files
%doc README.rst
%python3_sitelibdir/%mod_name/
%python3_sitelibdir/%{pyproject_distinfo %pypi_name}/

%changelog
