%define oname libacl

Name: python3-module-%oname
Version: 0.7.3
Release: alt1

Summary: POSIX.1e ACLs for python
License: LGPLv2.1+
Group: Development/Python3

URL: https://pypi.org/project/pylibacl
VCS: https://github.com/iustin/pylibacl

Source: %name-%version.tar
Patch: libacl-0.5.2-alt-doc.patch

BuildRequires(pre): rpm-build-python3
BuildRequires: python3-module-setuptools
BuildRequires: python3-module-wheel
BuildRequires(pre): rpm-macros-sphinx3
BuildRequires: libacl-devel
BuildRequires: python3-module-sphinx
BuildRequires: python3-module-recommonmark
BuildRequires: python3-module-myst-parser

%description
python-libacl is a C extension module for Python which implements
POSIX ACLs manipulation. It is a wrapper on top of the systems's
acl C library - see acl(5).

%prep
%setup
%patch -p1

# Fix shebang
sed -i "s/\(env python\)/\13/" setup.py

%prepare_sphinx3 .
ln -s ../objects.inv doc/

%build
%add_optflags -fno-strict-aliasing
%pyproject_build

%install
%pyproject_install

export PYTHONPATH=%buildroot%python3_sitelibdir
%make SPHINXBUILD="sphinx-build-3" doc

%files
%doc *.md doc/html
%python3_sitelibdir/posix1e.cpython-*.so
%python3_sitelibdir/pylibacl-%version.dist-info

%changelog
