%define _unpackaged_files_terminate_build 1
%define pypi_name lazy-object-proxy

%def_with check

Name: python3-module-%pypi_name
Version: 1.12.0
Release: alt1
Summary: A fast and thorough lazy object proxy
License: BSD-2-Clause
Group: Development/Python3
Url: https://pypi.org/project/lazy-object-proxy/
VCS: https://github.com/ionelmc/python-lazy-object-proxy.git
Source: %name-%version.tar
Source1: %pyproject_deps_config_name
Patch0: %name-%version-alt.patch
# manually manage runtime dependencies with metadata
AutoReq: yes, nopython3
%pyproject_runtimedeps_metadata
%py3_provides %pypi_name
Provides: python3-module-lazy_object_proxy = %EVR
Obsoletes: python3-module-lazy_object_proxy < %EVR
BuildRequires(pre): rpm-build-pyproject
%pyproject_builddeps_build
%if_with check
%add_pyproject_deps_check_filter objproxies hunter
%pyproject_builddeps_metadata
%pyproject_builddeps_check
%endif

%description
This Python module is based on wrapt's ObjectProxy with one big change: it
calls a function the first time the proxy object is used, while
wrapt.ObjectProxy just forwards the method calls to the target object.

%prep
%setup
%autopatch -p1
%pyproject_scm_init
%pyproject_deps_resync_build
%pyproject_deps_resync_metadata
%if_with check
%pyproject_deps_resync_check_tox tox.ini testenv
%endif

%build
%add_optflags -fno-strict-aliasing
%pyproject_build

%install
%pyproject_install

%check
%pyproject_run_pytest -ra -Wignore

%files
%doc README.*
%python3_sitelibdir/lazy_object_proxy/
%python3_sitelibdir/%{pyproject_distinfo %pypi_name}/

%changelog
