%define oname keyring

%def_with check

Name: python3-module-%oname
Version: 25.6.0
Release: alt2

Summary: Keyring provides an easy way to access the system keyring service

License: MIT
Group: Development/Python3
URL: https://pypi.org/project/keyring
VCS: https://github.com/jaraco/keyring

Source: %name-%version.tar

BuildArch: noarch

BuildRequires(pre): rpm-build-python3
BuildRequires: python3-module-setuptools
BuildRequires: python3-module-setuptools_scm
BuildRequires: python3-module-wheel
BuildRequires: python3-module-toml

%if_with check
BuildRequires: python3-module-pytest
BuildRequires: python3-module-importlib-metadata
BuildRequires: python3-module-secretstorage
BuildRequires: python3-module-jaraco.classes
BuildRequires: python3-module-jaraco.functools
BuildRequires: python3-module-jaraco.context
BuildRequires: python3-module-pyfakefs
%endif

# ALT#46056
Requires: python3-module-importlib_metadata

%description
The Python keyring lib provides an easy way to access the system
keyring service from python. It can be used in any application
that needs safe password storage.

%prep
%setup

# Drop redundant shebang
sed -i '1{\@^#!/usr/bin/env python@d}' keyring/cli.py

# Don't use SETUPTOOLS_SCM_PRETEND_VERSION.
# See: https://bugzilla.altlinux.org/46305
if [ ! -d .git ]; then
    git init
    git config user.email author@example.com
    git config user.name author
    git add .
    git commit -m 'release'
    git tag '%version'
fi

%build
%pyproject_build

%install
%pyproject_install

%check
%tox_check_pyproject

%files
%doc *.rst LICENSE
%_bindir/%oname
%python3_sitelibdir/%oname
%python3_sitelibdir/%{pyproject_distinfo %oname}

%changelog
