%define _unpackaged_files_terminate_build 1
%define pypi_name junos-eznc
%define mod_name junos

%def_with check

Name: python3-module-%pypi_name
Version: 2.7.5
Release: alt1
Summary: Junos 'EZ' automation for non-programmers
License: Apache-2.0
Group: Development/Python3
Url: https://pypi.org/project/junos-eznc/
VCS: https://github.com/Juniper/py-junos-eznc
BuildArch: noarch
Source: %name-%version.tar
Source1: %pyproject_deps_config_name
Patch0: %name-%version-alt.patch
# provide PyPI's name(dash and underscore)
%py3_provides %pypi_name
%pyproject_runtimedeps_metadata
BuildRequires(pre): rpm-build-pyproject
%pyproject_builddeps_build
%if_with check
%add_pyproject_deps_check_filter 'ntc-templates$'
%add_pyproject_deps_check_filter 'pep8$'
%pyproject_builddeps_metadata
%pyproject_builddeps_check
%endif

%description
Junos PyEZ is a Python library to remotely manage/automate Junos
devices. The user is NOT required: (a) to be a "Software Programmer",
(b) have sophisticated knowledge of Junos, or (b) have a complex
understanding of the Junos XML API.

%prep
%setup
%autopatch -p1
%pyproject_deps_resync_build
%pyproject_deps_resync_metadata
%if_with check
%pyproject_deps_resync_check_pipreqfile development.txt
%endif

# workaround for versioneer
rm versioneer.py
grep -qsF ' export-subst' .gitattributes || exit 1
vers_f="$(sed -n 's/ export-subst//p' .gitattributes)"
echo 'def get_versions():return {"version": "%version"}' > "$vers_f"
echo 'def get_cmdclass(): return {}' > versioneer.py
echo 'def get_version(): return "%version"' >> versioneer.py

%build
%pyproject_build

%install
%pyproject_install

%check
# .github/workflows/pylint.yml
%pyproject_run -- nose2 -vvv tests.unit

%files
# jnpr is the namespace package, don't own that directory
%python3_sitelibdir/junos_eznc-%version-py%_python3_version-nspkg.pth
%python3_sitelibdir/jnpr/%mod_name/
%python3_sitelibdir/%{pyproject_distinfo %pypi_name}/

%changelog
