%define _unpackaged_files_terminate_build 1
%define pypi_name isort

%def_with check

Name: python3-module-%pypi_name
Version: 6.0.1
Release: alt2
Summary: Python utility / library to sort Python imports
Group: Development/Python3
License: MIT
Url: https://pypi.org/project/isort
VCS: https://github.com/PyCQA/isort
BuildArch: noarch
Source: %name-%version.tar
Source1: %pyproject_deps_config_name
Patch: %name-%version-alt.patch
%add_python3_req_skip pylama.lint
%pyproject_runtimedeps_metadata
BuildRequires(pre): rpm-build-pyproject
%pyproject_builddeps_build
%if_with check
BuildRequires: /usr/bin/git
BuildRequires: python3-module-black
%add_pyproject_deps_check_filter cruft
%add_pyproject_deps_check_filter example-isort-sorting-plugin
%add_pyproject_deps_check_filter example-shared-isort-profile
%add_pyproject_deps_check_filter hypothesmith
%add_pyproject_deps_check_filter pep8-naming
%add_pyproject_deps_check_filter pip-api
%add_pyproject_deps_check_filter pipreqs
%add_pyproject_deps_check_filter portray
%add_pyproject_deps_check_filter requirementslib
%add_pyproject_deps_check_filter hatch
%pyproject_builddeps_metadata
%pyproject_builddeps_check
%endif

%description
Python utility / library to sort Python imports

%prep
%setup
%autopatch -p1

# remove bundled (for tests only) plugins/profiles,
# they cannot be loaded within venv and break tests assumptions
rm -r \
    example_shared_isort_profile \
    example_isort_sorting_plugin \
    example_isort_formatting_plugin \

# unvendor distributions
rm -r isort/_vendored/*

%pyproject_scm_init
%pyproject_deps_resync_build
%pyproject_deps_resync_metadata
%if_with check
%pyproject_deps_resync_check_depgroup dev
%endif

%build
%pyproject_build

%install
%pyproject_install
mv %buildroot%_bindir/isort{,.py3}

%check
%pyproject_run_pytest -vra tests/unit/

%files
%doc README.md
%_bindir/isort.py3
%_bindir/isort-identify-imports
%python3_sitelibdir/isort/
%python3_sitelibdir/%{pyproject_distinfo %pypi_name}/

%changelog
