%define oname influxdb

%def_with check

Name: python3-module-%oname
Version: 5.3.2
Release: alt2

Summary: Python client for InfluxDB

License: MIT
Group: Development/Python3
Url: https://github.com/influxdata/influxdb-python

Source: %name-%version.tar
Patch: remove-nose.patch
Patch1: remove-distutils-for-python-3.12.patch
Patch2: python-influxdb-new-pandas.patch

BuildArch: noarch

BuildRequires(pre): rpm-build-python3
%if_with check
BuildRequires: python3-module-pytest
BuildRequires: python3-module-msgpack
BuildRequires: python3-module-requests-mock
BuildRequires: python3-module-pytz
BuildRequires: python3-module-dateutil
BuildRequires: python3-module-pandas-tests
%endif

%add_python3_req_skip pandas

%description
InfluxDB-Python is a client for interacting with InfluxDB.

%package tests
Summary: Tests for %oname
Group: Development/Python3
Requires: %name = %EVR

%description tests
This package contains tests for %oname.

%prep
%setup
%patch -p1
%patch1 -p1
%patch2 -p1
sed -e 's/^import mock/from unittest import mock/' \
    -e 's/^from mock import/from unittest.mock import/' \
    -e 's/assertRaisesRegexp/assertRaisesRegex/' \
    -i influxdb/tests/*.py influxdb/tests/*/*.py

sed -i "s/freq='H'/freq='h'/g" influxdb/tests/dataframe_client_test.py

# for numpy2
sed -i "s/np.NaN/np.nan/" influxdb/tests/dataframe_client_test.py

%build
%python3_build

%install
%python3_install

%check
export PYTHONPATH=%buildroot%python3_sitelibdir
py.test-3 -k 'not test_write_points_from_dataframe_with_tags_and_nan_json and not testWarnBulkSizeNoEffect'

%files
%python3_sitelibdir/*
%doc docs/source examples README.rst
%exclude %python3_sitelibdir/%oname/tests

%files tests
%python3_sitelibdir/%oname/tests

%changelog
