%define _unpackaged_files_terminate_build 1
%define pypi_name importlib-resources

%def_with check

Name: python3-module-%pypi_name
Version: 6.5.2
Release: alt1
Summary: Read resources from Python packages
License: Apache-2.0
Group: Development/Python3
Url: https://pypi.org/project/importlib-resources
VCS: https://github.com/python/importlib_resources.git
BuildArch: noarch
Source: %name-%version.tar
Source1: %pyproject_deps_config_name
Patch: %name-%version-alt.patch
%pyproject_runtimedeps_metadata
Provides: python3-module-importlib_resources = %EVR
BuildRequires(pre): rpm-build-pyproject
%pyproject_builddeps_build
%if_with check
%pyproject_builddeps_metadata_extra test
# internal Python tests
BuildRequires: python3-test
%endif

%description
%pypi_name is a backport of Python standard library importlib.resources
module for older Pythons.

The key goal of this module is to replace parts of pkg_resources with a solution
in Python's stdlib that relies on well-defined APIs. This makes reading
resources included in packages easier, with more stable and consistent
semantics.

%prep
%setup
%autopatch -p1
%pyproject_scm_init
%pyproject_deps_resync_build
%pyproject_deps_resync_metadata

%build
%pyproject_build

%install
%pyproject_install

# don't ship tests
rm -r %buildroot%python3_sitelibdir/importlib_resources/tests/

%check
%pyproject_run_pytest -vra

%files
%doc README.rst
%python3_sitelibdir/importlib_resources/
%python3_sitelibdir/%{pyproject_distinfo %pypi_name}

%changelog
