%def_without check

%define oname icalendar

Name: python3-module-%oname
Version: 6.3.1
Release: alt1

Summary: iCalendar parser/generator
License: BSD-2-Clause
Group: Development/Python3
Url: https://pypi.org/project/icalendar/

BuildArch: noarch

Source: %oname-%version.tar.gz

BuildRequires(pre): rpm-build-python3
BuildRequires: python3-module-hatchling
BuildRequires: python3-module-wheel
BuildRequires: python3-module-sphinx
BuildRequires: python3-module-hatch-vcs
BuildRequires: python3-module-sphinx-copybutton
BuildRequires: python3-module-pydata-sphinx-theme

%if_with check
BuildRequires: python3-module-pytest
BuildRequires: python3-module-dateutil
BuildRequires: python3-module-pytz
BuildRequires: python3-module-coverage
BuildRequires: python3-module-hypothesis
%endif

%description
iCalendar is a parser/generator of iCalendar files
(RFC 2445) for use with Python.

%prep
%setup -n %oname-%version

%build
%pyproject_build 
pushd dist
wheel unpack %oname-%version-py3-none-any.whl
popd
PYTHONPATH=../dist/%oname-%version %make -C docs html BUILDDIR=build3 SPHINXBUILD=py3_sphinx-build

%install
%pyproject_install
rm %buildroot/%python3_sitelibdir_noarch/%oname/tests/fuzzed/*.sh 
rm %buildroot/%python3_sitelibdir_noarch/%oname/tests/*.sh 

%check
%pyproject_run_pytest src/icalendar/tests

%files
%doc docs/build3/html *.rst
%_bindir/*
%python3_sitelibdir_noarch/%oname
%python3_sitelibdir_noarch/%{pyproject_distinfo %oname}/

%changelog
