%define _unpackaged_files_terminate_build 1
%define pypi_name hypothesis
%define module_name %pypi_name

%def_with check
%def_without crosshair_check
%def_with relaxed_check

Name: python3-module-%pypi_name
Version: 6.142.5
Release: alt1

Summary: A library for property based testing
License: MPL-2.0-no-copyleft-exception
Group: Development/Python3
Url: https://pypi.org/project/hypothesis/
VCS: https://github.com/HypothesisWorks/hypothesis
BuildArch: noarch

Source: %name-%version.tar
Source1: pytest.ini
Source2: %pyproject_deps_config_name
Source3: test.in
Patch0: %name-%version-alt.patch

%pyproject_runtimedeps_metadata
BuildRequires(pre): rpm-build-pyproject
%pyproject_builddeps_build
%if_with check
%if_without crosshair_check
%add_pyproject_deps_check_filter hypothesis-crosshair
%add_pyproject_deps_check_filter crosshair-tool
%endif
%add_pyproject_deps_check_filter dpcontracts
%pyproject_builddeps_metadata_extra all
%pyproject_builddeps_check
# needed by pexpect
BuildRequires: /dev/pts
# filtered by default
BuildRequires: python3-module-black
# shipped in subpackage
BuildRequires: python3-module-numpy-testing
# not listed as tests' dependency
BuildRequires: python3-module-fakeredis
# pandas.testing is needed, but is in the separate rpm package
BuildRequires: python3-module-pandas-tests
%endif
%add_python3_req_skip dpcontracts pandas

# Manually manage extras dependencies with metadata.
AutoReq: yes, nopython3

%description
Hypothesis is an advanced testing library for Python. It lets you write tests
which are parametrized by a source of examples, and then generates simple and
comprehensible examples that make your tests fail. This lets you find more bugs
in your code with less work.

%prep
%setup
cp %SOURCE1 ./
%autopatch -p1
%pyproject_deps_resync_build
%pyproject_deps_resync_metadata
%if_with check
%pyproject_deps_resync_check_pipreqfile %SOURCE3
%endif

%build
%pyproject_build

%install
%pyproject_install

%check
# Ignoring of UserWarning for dateutile.zoneinfo is needed, because there's a
# flaw of python3-module-dateutil packaging and we don't create and package
# dateutil-zoneinfo.tar.gz. But it doesn't influence on the test execution.
%pyproject_run_pytest -ra -nauto -Wignore::UserWarning:dateutil.zoneinfo tests \
%if_without crosshair_check
	--ignore="tests/crosshair" \
%endif
%if_with relaxed_check
	||:
%endif
	%nil

%files
%doc README.md
%_bindir/hypothesis
%python3_sitelibdir/%module_name/
%python3_sitelibdir/%{pyproject_distinfo %pypi_name}/
%python3_sitelibdir/__pycache__/_hypothesis_pytestplugin.*
%python3_sitelibdir/_hypothesis_pytestplugin.py
%python3_sitelibdir/__pycache__/_hypothesis_ftz_detector.*
%python3_sitelibdir/_hypothesis_ftz_detector.py
%python3_sitelibdir/__pycache__/_hypothesis_globals.*
%python3_sitelibdir/_hypothesis_globals.py

%changelog
