%define _unpackaged_files_terminate_build 1
%define pypi_name h5netcdf

%def_with check

Name: python3-module-%pypi_name
Version: 1.6.1
Release: alt2

Summary: Pythonic interface to netCDF4 via h5py
License: BSD-3-Clause
Group: Development/Python3
Url: https://pypi.org/project/h5netcdf
VCS: https://github.com/shoyer/h5netcdf
BuildArch: noarch

Source0: %name-%version.tar
Source1: %pyproject_deps_config_name
%pyproject_runtimedeps_metadata

BuildRequires(pre): rpm-build-pyproject

%pyproject_builddeps_build

%if_with check
%pyproject_builddeps_metadata
%pyproject_builddeps_metadata_extra test
BuildRequires: python3-module-numpy-testing
%endif

%py3_provides %pypi_name
%py3_requires h5py

%description
A Python interface for the netCDF4 file-format that reads and writes
HDF5 files API directly via h5py, without relying on the Unidata netCDF
library.

This is an experimental project. It currently passes basic tests for
reading and writing netCDF4 files with Python, but it has not been
tested for compatibility with other netCDF4 interfaces.

%prep
%setup
%pyproject_deps_resync_build
%pyproject_deps_resync_metadata

%build

export SETUPTOOLS_SCM_PRETEND_VERSION="%version"
%pyproject_build

%install
%pyproject_install

%check
%pyproject_run_pytest

%files
%doc LICENSE *.rst
%python3_sitelibdir/h5netcdf/
%python3_sitelibdir/%{pyproject_distinfo %pypi_name}

%changelog
