%def_disable snapshot

%define _name gst-python
%define ver_major 1.26
%define gst_api_ver 1.0
%define _gst_libdir %_libdir/gstreamer-%gst_api_ver

%def_disable check

%ifarch %valgrind_arches
%def_enable valgrind
%endif

Name: python3-module-gst%gst_api_ver
Version: %ver_major.8
Release: alt1

Summary: GStreamer overrides for PyGobject3
Group: Development/Python3
License: LGPL-2.0-or-later
Url: http://gstreamer.freedesktop.org/

Provides: %_name = %version-%release

%if_disabled snapshot
Source: http://gstreamer.freedesktop.org/src/%_name/%_name-%version.tar.xz
%else
Source: %_name-%version.tar
%endif

BuildRequires(pre): rpm-macros-meson rpm-build-gir rpm-build-python3 rpm-macros-valgrind
BuildRequires: meson orc liborc-test-devel  gcc-c++ gst-plugins%gst_api_ver-devel >= %version
BuildRequires: python3-devel python3-module-pygobject3-devel python3-module-pytest
BuildRequires: pkgconfig(gstreamer-analytics-%gst_api_ver)
BuildRequires: pkgconfig(gstreamer-rtsp-server-%gst_api_ver)

%if_enabled valgrind
BuildRequires: valgrind-tool-devel
%endif
%{?_enable_check:BuildRequires: /proc gstreamer%gst_api_ver-utils gst-plugins-base%gst_api_ver}

%description
This package provides GStreamer overrides for PyGobject3.


%prep
%setup -n %_name-%version

%build
%meson \
    -Dlibpython-dir=%_libdir \
    -Dpygi-overrides-dir=%python3_sitelibdir/gi/overrides
%meson_build

%install
%meson_install

%check
%meson_test

%files
%_libdir/gstreamer-%gst_api_ver/libgstpython.so
%python3_sitelibdir/gi/overrides/*
%doc RELEASE NEWS

%changelog
