%define oname gmpy2

%def_with check

Name: python3-module-%oname
Version: 2.2.1
Release: alt1

Summary: GMP/MPIR, MPFR, and MPC interface

License: LGPL-3.0+
Group: Development/Python3
Url: https://github.com/aleaxit/gmpy

Source: %name-%version.tar

BuildRequires(pre): rpm-build-python3
BuildRequires: python3-devel
BuildRequires: libmpc-devel
BuildRequires: python3-module-setuptools
BuildRequires: python3-module-wheel

%if_with check
BuildRequires: python3-module-pytest
BuildRequires: python3-module-hypothesis
%endif

%description
A C-coded Python extension module that wraps the GMP library to provide
to Python code fast multiprecision arithmetic (integer, rational, and
float), random number generation, advanced number-theoretical functions,
and more.

%prep
%setup

%build
%pyproject_build

%install
%pyproject_install

%check
export PYTHONPATH=%buildroot%python3_sitelibdir
rm -rv gmpy2 build
%pyproject_run_pytest

%files
%doc README.rst
%python3_sitelibdir/%oname
%python3_sitelibdir/%oname-%version.dist-info

%changelog
