%define oname gevent

%def_disable embed

Name: python3-module-%oname
Version: 24.11.1
Release: alt1

Summary: Coroutine-based network library

License: MIT
Group: Development/Python3
Url: http://pypi.python.org/pypi/gevent

#add_findreq_skiplist %python_sitelibdir/gevent/_socket3.py
#add_python_req_skip test

# Source-url: %__pypi_url %oname
Source: %name-%version.tar

BuildRequires(pre): rpm-build-python3
BuildRequires(pre): rpm-build-intro >= 2.2.4

BuildRequires: libev-devel libuv-devel libcares-devel

BuildRequires: python3-module-repoze.sphinx.autointerface
BuildRequires: python3-module-greenlet-devel
BuildRequires: python3-module-OpenSSL
BuildRequires: python3-module-Cython python3-module-cryptography python3-module-html5lib

%py3_requires greenlet
%add_python3_req_skip gevent.libev._corecffi

%description
gevent is a coroutine-based Python networking library
that uses greenlet to provide a high-level synchronous API on top of the libev or libuv event loop.

Features include:
* Fast event loop based on libev or libuv.
* Lightweight execution units based on greenlets.
* API that re-uses concepts from the Python standard library (for examples there are events and queues).
* Cooperative sockets with SSL support
* Cooperative DNS queries performed through a threadpool, dnspython, or c-ares.
* Monkey patching utility to get 3rd party modules to become cooperative
* TCP/UDP/HTTP servers
* Subprocess support (through gevent.subprocess)
* Thread pools

%package -n python3-module-%oname-tests
Summary: Tests for %oname
Group: Development/Python3
Requires: %name = %EVR

%add_python3_self_prov_path %buildroot%python3_sitelibdir/%oname/tests/

%description -n python3-module-%oname-tests
This package contains tests for %oname.

%package -n python3-module-greentest
Summary: Tests for %oname
Group: Development/Python3
Requires: python3-module-%oname = %EVR
Requires: python3-module-%oname-tests = %EVR

%description -n python3-module-greentest
gevent is a coroutine-based Python networking library that uses greenlet
to provide a high-level synchronous API on top of libevent event loop.

This package contains tests for %oname.

%package doc
Summary: Documentation for gevent
Group: Development/Documentation
BuildArch: noarch

%description doc
gevent is a coroutine-based Python networking library that uses greenlet
to provide a high-level synchronous API on top of libevent event loop.

This package contains documentation and examples for gevent.

%prep
%setup

%if_disabled embed
rm -rf deps
%endif

# Force re-cythonizing the sources
rm $(grep -rl '/\* Generated by Cython')

%build
%add_optflags -fno-strict-aliasing
%if_disabled embed
export GEVENT_NO_CFFI_BUILD=1
export LIBEV_EMBED=0
export CARES_EMBED=0
%endif

export CYTHON=cython3
rm -fR src/gevent/_util_py2.py*
# remove all versions of greentest, leave only versions for current python3 version
pushd src/greentest
for i in * ; do
	if [ -z "$(echo $i | grep ^%__python3_version$)" ] ; then
		rm -fR $i
	fi
done
popd
%python3_build_debug

%install
%if_disabled embed
export GEVENT_NO_CFFI_BUILD=1
export LIBEV_EMBED=0
export CARES_EMBED=0
%endif

%python3_install
cp -fR src/greentest %buildroot%python3_sitelibdir/

#doc

#export PYTHONPATH=%buildroot%python_sitelibdir
#pushd doc
#make pickle
#make html

%files
%doc AUTHORS LICENSE* TODO *.rst
%python3_sitelibdir/*
%exclude %python3_sitelibdir/greentest
%exclude %python3_sitelibdir/%oname/tests
%exclude %python3_sitelibdir/%oname/testing

%files -n python3-module-%oname-tests
%python3_sitelibdir/%oname/tests/
%python3_sitelibdir/%oname/testing/

%files -n python3-module-greentest
%python3_sitelibdir/greentest

#files doc
#doc doc/_build/html
#doc examples

%changelog
