%define oname geojson

%def_with check

Name: python3-module-%oname
Version: 3.2.0
Release: alt1

Summary: Python bindings and utilities for GeoJSON

License: BSD-3-Clause
Group: Development/Python3
URL: https://pypi.org/project/geojson
VCS: https://github.com/jazzband/geojson

BuildArch: noarch

Source: %name-%version.tar

BuildRequires(pre): rpm-build-python3
BuildRequires: python3-module-setuptools
BuildRequires: python3-module-wheel

%if_with check
BuildRequires: python3-module-pytest
%endif

%py3_provides %oname
%py3_requires json

%description
This library contains:

* Functions for encoding and decoding GeoJSON formatted data
* Classes for all GeoJSON Objects
* An implementation of the Python __geo_interface__ Specification

%package examples
Summary: Examples for %oname
Group: Development/Python3
Requires: %name = %EVR

%description examples
This library contains:

* Functions for encoding and decoding GeoJSON formatted data
* Classes for all GeoJSON Objects
* An implementation of the Python __geo_interface__ Specification

This package contains examples for %oname.

%prep
%setup

%build
%pyproject_build

%install
%pyproject_install

%check
%pyproject_run_pytest

%files
%doc *.rst
%python3_sitelibdir/%oname
%python3_sitelibdir/%oname-%version.dist-info
%exclude %python3_sitelibdir/*/examples.*
%exclude %python3_sitelibdir/*/*/examples.*

%files examples
%python3_sitelibdir/*/examples.*
%python3_sitelibdir/*/*/examples.*

%changelog
