%define oname Flask-SQLAlchemy
%def_without docs
%def_with check

Name: python3-module-flask-sqlalchemy
Version: 3.1.1
Release: alt3

Summary: Adds SQLAlchemy support to your Flask application

License: BSD-3-Clause
Group: Development/Python3
URL: https://pypi.org/project/Flask-SQLAlchemy
VCS: https://github.com/pallets-eco/flask-sqlalchemy.git

Packager: Eugeny A. Rostovtsev (REAL) <real at altlinux.org>

# Source-url: %__pypi_url %oname
Source: %name-%version.tar
Patch: stop-using-utcnow.patch

BuildArch: noarch

BuildRequires(pre): rpm-build-intro >= 2.2.5
BuildRequires(pre): rpm-build-python3
BuildRequires(pre): rpm-macros-sphinx3
BuildRequires: python3-module-flit
BuildRequires: python3-module-pdm-pep517

%if_with check
BuildRequires: python3-module-pytest
BuildRequires: python3-module-sqlalchemy
BuildRequires: python3-module-flask
BuildRequires: python3-module-greenlet
%endif

%if_with docs
BuildRequires: python3-module-sphinx flask-sphinx-themes
%endif

Obsoletes: python3-module-flask_sqlalchemy
Provides: python3-module-flask_sqlalchemy

%description
Flask-SQLAlchemy is a Flask microframework extension which adds support
for the SQLAlchemy SQL toolkit/ORM.

%package docs
Summary: Documentation for %oname
Group: Development/Documentation
BuildArch: noarch

%description docs
Flask-SQLAlchemy is a Flask microframework extension which adds support
for the SQLAlchemy SQL toolkit/ORM.

This package contains documentation for %oname.

%prep
%setup
%patch -p1

%if_with docs
%prepare_sphinx3 .
ln -s ../objects.inv docs/
cp -fR %_datadir/flask-sphinx-themes/* docs/_themes/
%endif

%build
%pyproject_build

%if_with docs
export PYTHONPATH=$PWD
%make -C docs html SPHINXBUILD=sphinx-build-3
%endif

%install
%pyproject_install

%check
# skip tests that are broken with SQLAlchemy 2.0.36
# https://github.com/pallets-eco/flask-sqlalchemy/issues/1378
%pyproject_run_pytest -k 'not test_model_bind' -W ignore::pytest.PytestUnraisableExceptionWarning

%files
%doc README.rst
%python3_sitelibdir/*

%if_with docs
%files docs
%doc examples docs/_build/html
%endif

%changelog
