%define _unpackaged_files_terminate_build 1
%define pypi_name Flask-Cors
%define pypi_nname flask-cors
%define mod_name flask_cors

%def_with check

Name: python3-module-%pypi_nname
Version: 6.0.1
Release: alt1

Summary: Cross Origin Resource Sharing (CORS) support for Flask
License: MIT
Group: Development/Python3
Url: https://pypi.org/project/Flask-Cors/
Vcs: https://github.com/corydolphin/flask-cors

BuildArch: noarch

Source0: %name-%version.tar
Source1: %pyproject_deps_config_name
Patch0: %name-%version-alt.patch

%pyproject_runtimedeps_metadata
# well-known PyPI name
Provides: python3-module-%pypi_name = %EVR
BuildRequires(pre): rpm-build-pyproject
%pyproject_builddeps_build
%if_with check
%add_pyproject_deps_check_filter deptry
%add_pyproject_deps_check_filter tox-uv
%pyproject_builddeps_metadata
%pyproject_builddeps_check
%endif

%description
A Flask extension for handling Cross Origin Resource Sharing (CORS), making
cross-origin AJAX possible.

%prep
%setup
%autopatch -p1
echo '__version__ = "%version"' > flask_cors/version.py
sed -i 's/^version =.*$/version = "%version"/' pyproject.toml
%pyproject_deps_resync_build
%pyproject_deps_resync_metadata
%if_with check
%pyproject_deps_resync_check_depgroup dev
%endif

%build
%pyproject_build

%install
%pyproject_install

%check
%pyproject_run_pytest -vra -o=addopts=-Wignore

%files
%doc CHANGELOG.md LICENSE README.rst
%python3_sitelibdir/%mod_name/
%python3_sitelibdir/%{pyproject_distinfo %pypi_name}/

%changelog
