%define _unpackaged_files_terminate_build 1
%define pypi_name fastapi
%define module_name %pypi_name
%def_with check

Name: python3-module-%pypi_name
Version: 0.119.0
Release: alt1

Summary: FastAPI framework, high performance, easy to learn, fast to code, ready for production
License: MIT
Group: Development/Python3
Url: https://fastapi.tiangolo.com/
Vcs: https://github.com/fastapi/fastapi
BuildArch: noarch

Source0: %name-%version.tar
Source1: %pyproject_deps_config_name
Source2: clean_coverage_usage.py
Patch: %name-%version-alt.patch

# Some packages require fastapi-slim, but it's fastapi with the no installed
# certain requirements.
Provides: %name-slim = %EVR
# Filter fastapi-cli, because it's needed for managing fastapi project.
%add_pyproject_deps_runtime_filter fastapi-cli
%pyproject_runtimedeps_metadata
BuildRequires(pre): rpm-macros-pyproject
BuildRequires: rpm-build-pyproject
%pyproject_builddeps_build
%if_with check
# Upstream says that Argon2 has superiority over bcrypt
# See https://github.com/fastapi/fastapi/pull/13917
BuildRequires: python3-module-argon2-cffi
BuildRequires: python3-module-pytest-timeout
%pyproject_builddeps_metadata
%pyproject_builddeps_metadata -- --extra all
%pyproject_builddeps_check
%endif

%description
FastAPI is a modern, fast (high-performance), web framework for
building APIs with Python based on standard Python type hints.

The key features are:
- Fast: Very high performance, on par with NodeJS and Go (thanks to
  Starlette and Pydantic). One of the fastest Python frameworks
  available.
- Fast to code: Increase the speed to develop features by about 200%%
  to 300%%.
- Fewer bugs: Reduce about 40%% of human (developer) induced errors.
- Intuitive: Great editor support. Completion everywhere. Less time
  debugging.
- Easy: Designed to be easy to use and learn. Less time reading docs.
- Short: Minimize code duplication. Multiple features from each
  parameter declaration. Fewer bugs.
- Robust: Get production-ready code. With automatic interactive
  documentation.
- Standards-based: Based on (and fully compatible with) the open
  standards for APIs: OpenAPI (previously known as Swagger) and JSON
  Schema.

%prep
%setup
%autopatch -p1
%pyproject_deps_resync_build
%pyproject_deps_resync_metadata
%if_with check
cat requirements-docs-tests.txt requirements-tests.txt > alt-requirements-tests.txt
%pyproject_deps_resync_check_pipreqfile alt-requirements-tests.txt
%endif

%build
%pyproject_build

%install
%pyproject_install

%check
# Clean of the using coverage module, because we don't needs to it.
%SOURCE2 tests/
%pyproject_run -- bash -s <<-'ENDTESTS'
# Create symbolic link to python_multipart in order to make 'multipart' import
# name for passing tests since it was deleted in the python3-module-multipart
# 0.0.20-alt2.
ln -s %python3_sitelibdir/python_multipart \
	.run_venv/lib/python3/site-packages/multipart
python3 -m pytest -vvv -Wignore --timeout=300 tests
ENDTESTS

%files
%doc README.md LICENSE docs
%_bindir/%pypi_name
%python3_sitelibdir/%module_name/
%python3_sitelibdir/%{pyproject_distinfo %pypi_name}

%changelog
