%define oname dnspython

# Testing requires network access
%def_with check

Name: python3-module-dns
Version: 2.6.1
Release: alt1
Epoch: 1

Summary: DNS toolkit

License: ISC
Group: Development/Python
Url: http://www.dnspython.org

# Source-url: %__pypi_url %oname
Source: %name-%version.tar

BuildArch: noarch

BuildRequires(pre): rpm-build-intro >= 2.2.4
BuildRequires(pre): rpm-build-python3

BuildRequires: python3-module-hatchling
BuildRequires: pytest3

# optional
%add_python3_req_skip curio curio.socket
%add_python3_req_skip aioquic aioquic.quic.configuration aioquic.quic.connection aioquic.quic.events

%py3_provides %oname
Provides: python3-module-%oname

%description
dnspython is a DNS toolkit for Python. It supports almost all
record types. It can be used for queries, zone transfers, and dynamic
updates.  It supports TSIG authenticated messages and EDNS0.

dnspython provides both high and low level access to DNS. The high
level classes perform queries for data of a given name, type, and
class, and return an answer set.  The low level classes allow
direct manipulation of DNS zones, messages, names, and records.

%prep
%setup
rm -f examples/._*

%build
%pyproject_build

%install
%pyproject_install
%python3_prune

%check
py.test3 -v

%files
%doc README.md examples/ LICENSE
%python3_sitelibdir/*

%changelog
