%define oname django-guardian
%def_with check

Name: python3-module-%oname
Version: 3.2.0
Release: alt1

Summary: Implementation of per object permissions for Django 1.2 or later

License: BSD-2-Clause
Group: Development/Python3
Url: https://pypi.python.org/pypi/django-guardian

# https://github.com/lukaszb/django-guardian
Source: %name-%version.tar

BuildRequires(pre): rpm-build-python3
BuildRequires: python3-module-setuptools
BuildRequires: python3-module-wheel
BuildRequires: python3-module-django

%if_with check
BuildRequires: python3-module-pytest
BuildRequires: python3-module-pytest-django
BuildRequires: python3-module-django-environ
BuildRequires: python3-module-django-dbbackend-sqlite3
BuildRequires: python3-module-typing-extensions
%endif

%py3_provides %oname

BuildArch: noarch

%description
django-guardian is implementation of per object permissions as
authorization backend which is supported since Django 1.2. It won't work
with older Django releases.

%package tests
Summary: Tests for %oname
Group: Development/Python3
Requires: %name = %EVR

%description tests
django-guardian is implementation of per object permissions as
authorization backend which is supported since Django 1.2. It won't work
with older Django releases.

This package contains tests for %oname.

%prep
%setup

sed -i 's|#!/usr/bin/env python|#!/usr/bin/env python3|' \
    $(find ./ -name '*.py')

%build
%pyproject_build

%install
%pyproject_install

install -d %buildroot%python3_sitelibdir/%oname

%check
py.test-3 -v

%files
%doc LICENSE *.md
%python3_sitelibdir/guardian
%python3_sitelibdir/django_guardian-%version.dist-info
%exclude %python3_sitelibdir/guardian/test*
%exclude %python3_sitelibdir/guardian/*/test*

%files -n python3-module-%oname-tests
%python3_sitelibdir/guardian/test*
%python3_sitelibdir/guardian/*/test*

%changelog
