%define oname django-debug-toolbar

Name: python3-module-%oname
Version: 6.1.0
Release: alt1

Summary: A configurable set of panels that display various debug information about the current request/response.
License: BSD-3-Clause
Group: Development/Python3
Url: https://github.com/jazzband/django-debug-toolbar
BuildArch: noarch

Source: %name-%version.tar

BuildRequires(pre): rpm-build-python3
BuildRequires: python3-module-setuptools python3-module-wheel
BuildRequires: python3-module-django
BuildRequires: python3-module-hatchling
#BuildRequires: python3-module-sphinx

%description
The Django Debug Toolbar is a configurable set of panels that
display various debug information about the current request/response
and when clicked, display more details about the panel's content.

%package docs
Summary: Documentation for %name
Group: Development/Documentation
Requires: %name = %version-%release

%description docs
This is a fork of Rob Hudson's Debug Toolbar. It includes an
alternative style, performance optimizations, and some panels which
may not be available in the main repository.

This package contains documentation for %name

%prep
%setup

sed -i 's|sphinx-build|sphinx-build-3|' docs/Makefile

sed -i 's|from.*Command|# from.*Command|' \
    $(find ./ -name 'debugsqlshell.py')

sed -i 's|#!/usr/bin/env python|#!/usr/bin/env python3|' \
    $(find ./ -name '*.py')

%build
%pyproject_build

#export PYTHONPATH=$PWD
#%%make -C docs man

%install
%pyproject_install

%files
%doc README.rst LICENSE
%python3_sitelibdir/*

#%%files docs
#%%doc docs/_build/* example

%changelog
