%define modname decorator

Name: python3-module-%modname
Version: 5.2.1
Release: alt1

Summary: Better living through Python with decorators

License: BSD-2-Clause
Group: Development/Python3
URL: https://pypi.org/project/decorator
VCS: https://github.com/micheles/decorator

Source: %name-%version.tar

BuildArch: noarch

BuildRequires(pre): rpm-build-python3
BuildRequires: python3-module-setuptools
BuildRequires: python3-module-wheel

%description
Python decorators are an interesting example of why syntactic sugar
matters. In principle, their introduction in Python changed nothing,
since they do not provide any new functionality which was not already
present in the language. In practice, their introduction has
significantly changed the way we structure our programs in Python. I
believe the change is for the best, and that decorators are a great idea
since:

* decorators help reducing boilerplate code;

* decorators help separation of concerns;

* decorators enhance readability and maintenability;

* decorators are explicit.

%prep
%setup

%build
%pyproject_build

%install
%pyproject_install

%files
%doc CHANGES.md LICENSE.txt README.rst
%python3_sitelibdir/%modname.py
%python3_sitelibdir/__pycache__
%python3_sitelibdir/%modname-%version.dist-info

%changelog
