%define _unpackaged_files_terminate_build 1

%def_without check

%define oname dateutil
%define pypi_name python-dateutil

Name: python3-module-%oname
Version: 2.9.0.post0
Release: alt1

Summary: Extensions to the standard datetime module

License: PSF
Group: Development/Python
Url: https://pypi.python.org/pypi/python-dateutil/

BuildArch: noarch

Packager: Vitaly Lipatov <lav@altlinux.ru>

%add_python3_req_skip _winreg winreg

# Source-url: %__pypi_url python-dateutil
Source: %name-%version.tar

Patch1: %oname-2.7.3-alt-tests.patch
# mapping from PyPI name
Provides: python3-module-%{pep503_name %pypi_name} = %EVR

BuildRequires: tzdata

BuildRequires(pre): rpm-build-python3
BuildRequires: python3-devel python3-module-setuptools
BuildRequires: python3(setuptools_scm)
%if_with check
BuildRequires: python3(pytest) python3(hypothesis) python3(freezegun)
BuildRequires: python3-module-pytest-cov
%endif

BuildRequires(pre): rpm-build-intro

Requires: tzdata

%description
The dateutil module provides powerful extensions to the standard
datetime module, available in Python 2.3+. Allows:
- computing of relative deltas (next month, next year, next monday,
  last week of month, etc),
- computing of dates based on very flexible recurrence rules, using a
  superset of the [WWW] iCalendar specification,
- parsing of RFC strings,
- peneric parsing of dates in almost any string format.

%prep
%setup
%patch1 -p1
# FIXME: Make sure a unicode string can be passed to TZ (GH #802)
%__subst "s|test_gettz_badzone_unicode|disabled_test_gettz_badzone_unicode|" tests/test_tz.py

%build
export SETUPTOOLS_SCM_PRETEND_VERSION=%version
%python3_build

%install
export SETUPTOOLS_SCM_PRETEND_VERSION=%version
%python3_install

%if_with check
%check
export SETUPTOOLS_SCM_PRETEND_VERSION=%version
py.test3
%endif

%files
%doc LICENSE NEWS README*
%python3_sitelibdir/*egg-info/
%python3_sitelibdir/dateutil

%changelog
