%define _unpackaged_files_terminate_build 1
%define oname ctypesgen

%def_with check

Name: python3-module-%oname
Version: 1.1.1
Release: alt1.1

Summary: Python wrapper generator for ctypes
License: BSD-2-Clause
Group: Development/Python3
Url: https://pypi.org/project/ctypesgen/
Vcs: https://github.com/ctypesgen/ctypesgen

Source: %name-%version.tar

BuildArch: noarch

BuildRequires(pre): rpm-build-python3
BuildRequires: python3-module-setuptools
BuildRequires: python3-module-setuptools_scm
BuildRequires: python3-module-wheel
%if_with check
BuildRequires: python3-module-pytest
%endif

%description
ctypesgen is a pure-python ctypes wrapper generator. It parses C header files
and creates a wrapper for libraries based on what it finds.
Preprocessor macros are handled in a manner consistent with typical C code.
Preprocessor macro functions are translated into Python functions that are
then made available to the user of the newly-generated Python wrapper library.
It can also output JSON, which can be used with Mork, which generates bindings
for Lua, using the alien module (which binds libffi to Lua).

%prep
%setup

if [ ! -d .git ]; then
    git init
    git config user.email author@example.com
    git config user.name author
    git add .
    git commit -m 'release'
    git tag '%version'
fi

%build
%pyproject_build

%install
%pyproject_install

%check
%tox_check_pyproject

%files
%doc LICENSE *.md
%_bindir/*
%python3_sitelibdir/%oname
%python3_sitelibdir/%{pyproject_distinfo %oname}


%changelog
