%define oname cryptography

# See - https://github.com/pyca/cryptography/issues/9023
%define optflags_lto %nil

%def_disable test

Name: python3-module-%oname
Version: 46.0.2
Release: alt1

Summary: Cryptographic recipes and primitives to Python developers

License: Apache-2.0
Group: Development/Python3
Url: https://pypi.python.org/pypi/cryptography/

Packager: Vladimir Didenko <cow@altlinux.org>

# Source-url: %__pypi_url %oname
Source: %name-%version.tar

# see gear/predownloaded-preinstall-hook
Source1: %name-development-%version.tar

BuildRequires(pre): rpm-build-intro >= 2.2.4
BuildRequires(pre): rpm-build-python3

BuildRequires: python3-devel python3-module-cffi
BuildRequires: python3(setuptools)
BuildRequires: python3(wheel)
BuildRequires: libssl-devel
BuildRequires: /proc
BuildRequires: rust rust-cargo python3-module-setuptools_rust
BuildRequires: python3-module-toml python3-module-semantic_version
BuildRequires: python3-module-asn1crypto >= 0.21.0
BuildRequires: python3-module-maturin
%if_enabled test
BuildRequires: python3-module-cryptography-vectors
BuildRequires: python3-module-pretend python3-module-iso8601 python3-module-pytz
BuildRequires: python3-module-pytest >= 3.9.3
BuildRequires: python3-module-hypothesis
%endif

%py3_requires cffi

%description
cryptography is a package which provides cryptographic recipes and primitives to Python developers.
Our goal is for it to be your "cryptographic standard library". cryptography includes both high level
recipes, and low level interfaces to common cryptographic algorithms such as symmetric ciphers, message
digests and key derivation functions.


%prep
%setup -a1

mkdir -p .cargo
cat >> .cargo/config.toml <<EOF
[source.crates-io]
replace-with = "vendored-sources"

[source.vendored-sources]
directory = "src/rust/vendor"
EOF

%build
export CARGO_NET_OFFLINE=true
export OPENSSL_INCLUDE_DIR="%_includedir"
export OPENSSL_LIB_DIR="%_libdir"
export OPENSSL_NO_VENDOR=1
%pyproject_build

%install
%pyproject_install

%filter_from_requires /python3[(]cryptography.hazmat.bindings._commoncrypto[)]/d
%filter_from_requires /python3[(]cryptography.hazmat.bindings._constant_time[)]/d
%filter_from_requires /python3[(]cryptography.hazmat.bindings._openssl[)]/d
%filter_from_requires /python3[(]cryptography.hazmat.bindings._padding[)]/d
%filter_from_requires /python3[(]cryptography.hazmat.bindings._rust[)]/d

%if_enabled test
%check
py.test3
%endif


%files
%python3_sitelibdir/%oname/
%python3_sitelibdir/%oname-%version.dist-info/

%changelog
