%define _unpackaged_files_terminate_build 1
%define oname clang
%define llvm_ver 19.1
%define git 4fb1d60

%def_without check

Name:       python3-module-%oname
Version:    19.1.3
Release:    alt0.1.g%{git}

Summary:    Libclang python bindings
License:    Apache-2.0
Group:      Development/Python3
Url:        https://pypi.org/project/libclang/
VCS:        https://github.com/sighingnow/libclang

Source0:    %name-%version.tar

BuildRequires(pre): rpm-build-python3
BuildRequires: python3-module-setuptools
BuildRequires: python3-module-wheel
BuildRequires: clang%{llvm_ver}-devel
BuildRequires: llvm%{llvm_ver}-devel

%description
The aim of this project is to make the clang.cindex
(aka., Clang Python Bindings) available for more Python users, without setting
up the LLVM environment.

%prep
%setup

%build
%pyproject_build

%install
%pyproject_install

%if "%python3_sitelibdir_noarch" != "%python3_sitelibdir"
install -d %buildroot%python3_sitelibdir
mv %buildroot%python3_sitelibdir_noarch/* \
	%buildroot%python3_sitelibdir/
%endif

# Using system libclang.so
export ALTWRAP_LLVM_VERSION=%llvm_ver
libdir=$(llvm-config --libdir)
ln -s $libdir/libclang.so %buildroot%python3_sitelibdir/%oname/native/libclang.so

%files
%doc LICENSE.TXT README.md
%python3_sitelibdir/%oname
%python3_sitelibdir/lib%oname-%version.dist-info

%changelog
