%define modulename cheroot

%def_with check
# Nessesary for cherrypy
%def_with tests

Name:    python3-module-%modulename
Version: 11.1.2
Release: alt1

Summary: Cheroot is the high-performance, pure-Python HTTP server used by CherryPy
License: BSD-3-Clause
Group:   Development/Python
URL:     https://pypi.org/project/cheroot
VCS:     https://github.com/cherrypy/cheroot

Source: %name-%version.tar
Patch0: %name-%version-%release.patch

BuildRequires(pre): rpm-build-pyproject
Source1: %pyproject_deps_config_name
%pyproject_runtimedeps_metadata
%pyproject_builddeps_build
%if_with check
BuildRequires: python3(pytest_cov)
%add_pyproject_deps_check_filter pypytools pytest-clarity
%pyproject_builddeps_metadata
%pyproject_builddeps_check
%endif
BuildArch: noarch

%description
Cheroot is the high-performance, pure-Python HTTP server used by CherryPy.

%package tests
Summary: Tests for Cheroot
Group: Development/Python
Requires: %name = %EVR

%description tests
This package contains tests for Cheroot

%prep
%setup
%patch0 -p1
%pyproject_deps_resync_build
%pyproject_deps_resync_metadata
%if_with check
%pyproject_deps_resync_check_pipreqfile dependencies/tests.in
%endif

%build
export SETUPTOOLS_SCM_PRETEND_VERSION=%version
%pyproject_build

%install
export SETUPTOOLS_SCM_PRETEND_VERSION=%version
%pyproject_install
%if_without tests
rm -rf %python3_sitelibdir/%{modulename}/test
rm -f %python3_sitelibdir/%{modulename}/testing.py
%endif

%check
# see cheroot/test/conftest.py
export HTTP_REQUEST_TIMEOUT=3
%pyproject_run_pytest -vra

%files
%_bindir/cheroot
%python3_sitelibdir/%modulename-%version.dist-info
%python3_sitelibdir/%{modulename}*
%exclude %python3_sitelibdir/%{modulename}/test
%exclude %python3_sitelibdir/%{modulename}/testing.py

%if_with tests
%files tests
%python3_sitelibdir/%{modulename}/test
%python3_sitelibdir/%{modulename}/testing.py
%endif

%changelog
