%define _unpackaged_files_terminate_build 1

%define oname celery

%add_python3_req_skip celery.utils.nodenames
%add_python3_req_skip celery.utils.time

%def_with eventlet
%def_without s3
# wait for new botocore, pytest
%def_disable check
# AttributeError: module 'sphinx.ext.autodoc' has no attribute 'AutoDirective'
%def_without doc

Name: python3-module-%oname
Version: 5.3.6
Release: alt2

Summary: Celery is an open source asynchronous task queue/job queue based on distributed message passing
License: BSD License
Group: Development/Python3

URL: https://github.com/celery/celery
# https://github.com/celery/celery.git
# Source-url: https://pypi.io/packages/source/c/%oname/%oname-%version.tar.gz
Source: %name-%version.tar

#Patch1: %oname-%version-alt-tests.patch

# Patches from Debian
Patch10: 0005-Disable-pytest-3.3-log-capturing-to-avoid-changing-l.patch
Patch11: 0007-Set-shell-in-su-invocation.patch
Patch12: privacy.patch

BuildRequires(pre): rpm-build-intro
BuildRequires(pre): rpm-build-python3
BuildRequires: dvipng

BuildRequires: python3-module-html5lib
BuildRequires: python3(Crypto)
BuildRequires: python3-module-django python3-module-ecdsa python3-module-pytz python3(requests)
BuildRequires: python3(redis)

%if_with doc
BuildRequires(pre): rpm-macros-sphinx3
BuildRequires: python3(sphinx_celery)
BuildRequires: python3-module-sphinx
%endif

%py3_use kombu >= 4.6.10
%py3_use billiard >= 3.6.3
%py3_use vine >= 1.3.0

%if_enabled check
# /proc is required for some tests
BuildRequires: /proc
BuildRequires: python3-module-botocore >= 1.10.29
BuildRequires: python3-module-botocore < 1.11.0
BuildRequires: python3-module-mock
BuildRequires: python3-module-pytest >= 4.3.1
BuildRequires: python3-module-pytest < 4.4.0
%endif

%if_with s3
BuildRequires: python3-module-moto >= 1.3.7
%endif

%if_with eventlet
BuildRequires: python3(eventlet)
%endif

%description
Celery is an open source asynchronous task queue/job queue based on
distributed message passing.  It is focused on real-time operation,
but supports scheduling as well.

The execution units, called tasks, are executed concurrently on one
or more worker nodes using multiprocessing, `Eventlet`_ or `gevent`_.
Tasks can execute asynchronously (in the background) or synchronously
(wait until ready).

Celery is used in production systems to process millions of tasks a day.

%package docs
Summary: Documentation for %oname
Group: Development/Documentation
BuildArch: noarch

%description docs
Celery is an open source asynchronous task queue/job queue based on
distributed message passing.  It is focused on real-time operation,
but supports scheduling as well.

The execution units, called tasks, are executed concurrently on one
or more worker nodes using multiprocessing, `Eventlet`_ or `gevent`_.
Tasks can execute asynchronously (in the background) or synchronously
(wait until ready).

Celery is used in production systems to process millions of tasks a day.

This package contains documentation for %oname.

%package sphinx
Summary: Sphinx documentation plugin used to document tasks
Group: Development/Python3
Requires: %name = %EVR

%description sphinx
Sphinx documentation plugin used to document tasks.

%prep
%setup
#patch1 -p1
#patch10 -p1
%patch11 -p1
#patch12 -p1

# avoid using moto (needed for S3 tests)
subst "s|moto==.*||" requirements/test.txt

%build
# skip using moto
rm -fv celery/t/unit/backends/test_s3.py

%python3_build_debug

%install
%python3_install

# FIXME: hack
%if "%_target_libdir_noarch" != "%_libdir"
mv %buildroot%_target_libdir_noarch %buildroot%_libdir
%endif

%if_with doc
%make -C docs html SPHINXBUILD=sphinx-build-3
%endif

%check
rm -f t/unit/contrib/test_sphinx.py
%python3_test

%files
%doc *.txt *.rst TODO
%_bindir/*
%python3_sitelibdir/celery*
%exclude %python3_sitelibdir/celery/contrib/sphinx.py

%files sphinx
%python3_sitelibdir/celery/contrib/sphinx.py

%if_with doc
%files docs
%doc docs/_build/html/*
%endif

%changelog
