%define _unpackaged_files_terminate_build 1
%define pypi_name blessed
%define mod_name %pypi_name

%def_with check

Name: python3-module-%pypi_name
Version: 1.25.0
Release: alt1
Summary: Easy, practical library for making terminal apps
License: MIT
Group: Development/Python3
Url: https://pypi.org/project/blessed/
Vcs: https://github.com/jquast/blessed.git
BuildArch: noarch
Source: %name-%version.tar
Source1: %pyproject_deps_config_name
Patch0: %name-%version-alt.patch
# manually manage runtime dependencies with metadata
AutoReq: yes, nopython3
Requires: python3-modules-curses
%pyproject_runtimedeps_metadata
BuildRequires(pre): rpm-build-pyproject
%pyproject_builddeps_build
%if_with check
BuildRequires: /dev/pts
BuildRequires: python3-modules-curses
%pyproject_builddeps_metadata
%pyproject_builddeps_check
%endif

%description
Easy, practical library for making terminal apps, by providing an elegant,
well-documented interface to Colors, Keyboard input, and screen Positioning
capabilities.

%prep
%setup
%autopatch -p1
%python3_fix_shebang .
%pyproject_deps_resync_build
%pyproject_deps_resync_metadata
%if_with check
%pyproject_deps_resync_check_tox tox.ini testenv
%endif

%build
%pyproject_build

%install
%pyproject_install

%check
# skip timing-sensitive tests
export TEST_QUICK=1
%pyproject_run_pytest -vra -o=addopts=-Wignore tests

%files
%doc README.rst
%python3_sitelibdir/%mod_name/
%python3_sitelibdir/%{pyproject_distinfo %pypi_name}/

%changelog
