%define _unpackaged_files_terminate_build 1
%define pypi_name beautifulsoup4
%define mod_name bs4

%def_with check

%define add_python_extra() \
%{expand:%%package -n %%name+%1 \
Summary: %%summary \
Group: Development/Python3 \
Requires: %%name \
%%pyproject_runtimedeps_metadata_extra %1 \
%%description -n %%name+%1' \
Extra "%1" for %%pypi_name. \
%%files -n %%name+%1 \
}

Name: python3-module-%pypi_name
Version: 4.14.2
Release: alt1
Summary: Screen-scraping library
License: MIT
Group: Development/Python3
Url: https://pypi.org/project/beautifulsoup4/
Vcs: https://git.launchpad.net/beautifulsoup
BuildArch: noarch
Source: %name-%version.tar
Source1: %pyproject_deps_config_name
Provides: python3-module-BeautifulSoup4 = %EVR
Obsoletes: python3-module-BeautifulSoup4
# manually manage runtime dependencies with metadata
AutoReq: yes, nopython3
%pyproject_runtimedeps_metadata
BuildRequires(pre): rpm-build-pyproject
%pyproject_builddeps_build
%if_with check
%pyproject_builddeps_metadata
%pyproject_builddeps_check
%endif

%description
Beautiful Soup is a Python library designed for quick turnaround projects like
screen-scraping. Three features make it powerful:
- Beautiful Soup provides a few simple methods and Pythonic idioms for
  navigating, searching, and modifying a parse tree: a toolkit for dissecting a
  document and extracting what you need. It doesn't take much code to write an
  application
- Beautiful Soup automatically converts incoming documents to Unicode and
  outgoing documents to UTF-8. You don't have to think about encodings, unless
  the document doesn't specify an encoding and Beautiful Soup can't detect one.
  Then you just have to specify the original encoding.
- Beautiful Soup sits on top of popular Python parsers like lxml and html5lib,
  allowing you to try out different parsing strategies or trade speed for
  flexibility.

%add_python_extra lxml
%add_python_extra html5lib

%prep
%setup
%pyproject_deps_resync_build
%pyproject_deps_resync_metadata
%if_with check
%pyproject_deps_resync_check_tox tox.ini testenv
%endif

%build
%pyproject_build

%install
%pyproject_install

%check
%pyproject_run_pytest -vra

%files
%doc README.md
%python3_sitelibdir/%mod_name/
%python3_sitelibdir/%{pyproject_distinfo %pypi_name}/

%changelog
