%define _unpackaged_files_terminate_build 1

# wait for python module importlib_resources
# https://bugzilla.altlinux.org/39327
%def_without check

%define oname apptools

Name:           python3-module-%oname
Version:        5.3.0
Release:        alt1

Summary:        Enthough Tool Suite Application Tools

License:        BSD and LGPLv2+
Group:          Development/Python3
URL:            https://docs.enthought.com/apptools/

# Source-url: https://github.com/enthought/apptools/archive/refs/tags/%version.tar.gz
Source:         %name-%version.tar
Source1:        README.fedora.python-AppTools

# Users of Python 3.9 and beyond should use the standard library module
Patch1: apptools-5.1.0-python3.9-compat.patch

BuildArch:      noarch

#if_with check
BuildRequires: xvfb-run unzip

BuildRequires(pre): rpm-build-intro >= 2.2.5
BuildRequires(pre): rpm-build-python3
BuildRequires: python3 >= 3.8
#BuildRequires: python3-devel python3-module-setuptools
BuildRequires: python3(tables)
#BuildRequires: python3-module-setupdocs python3-module-sphinx-devel
# for 2to3
BuildRequires: python3-tools
%if_with check
BuildRequires: python3-module-pytest
BuildRequires: python3-module-traits-tests
BuildRequires: python3-module-pyface
BuildRequires: python3-module-numpy-testing
BuildRequires: python3(tables.tests)
BuildRequires: python3(pandas)
%endif

%add_python3_req_skip traits.protocols.api
%add_python3_req_skip new wx
%add_python3_req_skip codetools.contexts.api

%description
The AppTools project includes a set of packages that Enthought has
found useful in creating a number of applications. They implement
functionality that is commonly needed by many applications

    * enthought.appscripting: Framework for scripting applications.

    * enthought.help: Provides a plugin for displaying documents and
      examples and running demos in Envisage Workbench applications.

    * enthought.io: Provides an abstraction for files and folders in a
      file system.

    * enthought.naming: Manages naming contexts, supporting non-string
      data types and scoped preferences

    * enthought.permissions: Supports limiting access to parts of an
      application unless the user is appropriately authorised (not
      full-blown security).

and many more.

%package tests
Summary: Tests for AppTools
Group: Development/Python3
Requires: %name = %EVR
%add_python3_req_skip apptools.template.impl.base_data_context_adapter
%add_python3_req_skip blockcanvas.app.utils
%add_python3_req_skip chaco.api
%add_python3_req_skip chaco.scatter_markers
%add_python3_req_skip chaco.tools.api
%add_python3_req_skip enable.wx_backend.api
%add_python3_req_skip etsdevtools.developer.features.api
%add_python3_req_skip etsdevtools.developer.helper.themes
%add_python3_req_skip traitsui.wx.themed_slider_editor
%add_python3_req_skip traitsui.wx.themed_text_editor

%description tests
The AppTools project includes a set of packages that Enthought has
found useful in creating a number of applications.

This package contains tests for AppTools.

%package docs
Summary: Documentation for AppTools
Group: Development/Documentation
BuildArch: noarch

%description docs
The AppTools project includes a set of packages that Enthought has
found useful in creating a number of applications.

This package contains documentation for AppTools.

%prep
%setup
#patch1 -p2

%if_with doc
%prepare_sphinx3 docs/source
%endif

%build
%python3_build

#sphinx-build -E -a -b html -c docs/source -d doctrees docs/source html

%install
install -p -m644 %SOURCE1 README.fedora
%python3_install
%python3_prune

%check
#  Note: if the cwd is somewhere under /tmp, that confuses test_file_path.py
xvfb-run py.test3

%files
%doc image_LICENSE*.txt LICENSE.txt
%doc README.fedora README.rst
%python3_sitelibdir/*
%if 0
%exclude %python3_sitelibdir/%oname/*/test*
%exclude %python3_sitelibdir/%oname/*/*/test*
%exclude %python3_sitelibdir/%oname/*/*/example*
%exclude %python3_sitelibdir/%oname/*/*/*/example*
%exclude %python3_sitelibdir/%oname/*/*/*/*/example*

%files tests
%python3_sitelibdir/%oname/*/test*
%python3_sitelibdir/%oname/*/*/test*
%python3_sitelibdir/%oname/*/*/example*
%python3_sitelibdir/%oname/*/*/*/example*
%python3_sitelibdir/%oname/*/*/*/*/example*
%endif

%if_with doc
%files docs
%doc examples html
%endif


%changelog
