%define oname apipkg

%def_with check

Name:           python3-module-%oname
Version:        3.0.2
Release:        alt1.1

Summary:        A Python namespace control and lazy-import mechanism

License:        MIT
Group:          Development/Python3
URL:            https://pypi.org/project/apipkg
VCS:            https://github.com/pytest-dev/apipkg

Source:        %name-%version.tar

BuildArch:      noarch

BuildRequires(pre): rpm-build-python3
BuildRequires: python3-module-hatchling
BuildRequires: python3-module-hatch-vcs
%if_with check
BuildRequires: python3-module-pytest
%endif

%description
With apipkg you can control the exported namespace of a Python package
and greatly reduce the number of imports for your users. It is a small pure
Python module that works on CPython 3.7+, Jython and PyPy. It cooperates well
with Python's help() system, custom importers (PEP302) and common
command-line completion tools.

Usage is very simple: you can require 'apipkg' as a dependency or you can
copy paste the ~200 lines of code into your project.

%prep
%setup

%build
export SETUPTOOLS_SCM_PRETEND_VERSION=%version
%pyproject_build

%install
%pyproject_install

%check
%tox_check_pyproject -- -k'not test_get_distribution_version'

%files
%python3_sitelibdir/%oname
%python3_sitelibdir/%oname-%version.dist-info

%changelog
