%define oname SQLObject

%def_with check

Name: python3-module-%oname
Version: 3.10.2
Release: alt1.2.1

Summary: SQLObject, an object-relational mapper for Python
License: LGPL-2.1
Group: Development/Python3
Url: https://pypi.org/project/SQLObject/
VCS: https://github.com/sqlobject/sqlobject.git

Source: %name-%version.tar

BuildArch: noarch

BuildRequires(pre): rpm-build-python3
BuildRequires: python3-module-setuptools
BuildRequires: python3-module-wheel
%if_with check
BuildRequires: python3-module-pydispatcher
BuildRequires: python3-module-FormEncode
BuildRequires: python3-module-pytest
%endif

%description
SQLObject is a popular Object Relational Manager for providing an object
interface to your database, with tables as classes, rows as instances,
and columns as attributes.

SQLObject includes a Python-object-based query language that makes SQL
more abstract, and provides substantial database independence for applications.

%package doc
Summary: This package contains documentation for SQLObject
Group: Development/Documentation

%description doc
SQLObject is a popular Object Relational Manager for providing an object
interface to your database, with tables as classes, rows as instances,
and columns as attributes.

SQLObject includes a Python-object-based query language that makes SQL
more abstract, and provides substantial database independence for applications.

%package tests
Summary: Tests for %oname
Group: Development/Python3
Requires: %name = %EVR

%description tests
SQLObject is a popular Object Relational Manager for providing an object
interface to your database, with tables as classes, rows as instances,
and columns as attributes.

SQLObject includes a Python-object-based query language that makes SQL
more abstract, and provides substantial database independence for applications.

This package contains tests for %oname

%prep
%setup

%build
%pyproject_build

%install
%pyproject_install

%check
%tox_check_pyproject

%files
%doc LICENSE *.rst
%_bindir/*
%python3_sitelibdir/sqlobject
%python3_sitelibdir/%{pyproject_distinfo %oname}/
%exclude %python3_sitelibdir/sqlobject/tests
%exclude %python3_sitelibdir/sqlobject/*/tests
%exclude %python3_sitelibdir/sqlobject/*/test
%exclude %python3_sitelibdir/sqlobject/conftest.py
%exclude %python3_sitelibdir/sqlobject/*/conftest*

%files tests
%python3_sitelibdir/sqlobject/tests
%python3_sitelibdir/sqlobject/*/tests
%python3_sitelibdir/sqlobject/*/test
%python3_sitelibdir/sqlobject/conftest.py
%python3_sitelibdir/sqlobject/*/conftest*

%files doc
%doc docs/*

%changelog
