%define _unpackaged_files_terminate_build 1

%define oname PasteScript

%def_with check

%def_without bootstrap

Name: python3-module-%oname
Epoch:   1
Version: 3.7.0
Release: alt1.1
Summary: A pluggable command-line frontend
License: MIT/X11
Group: Development/Python3
Url: https://pypi.org/project/PasteScript/

BuildArch: noarch

Source: %oname-%version.tar

%py3_provides %oname

%if_without bootstrap
BuildRequires: python3-module-PasteDeploy
BuildRequires: python3-module-paste
BuildRequires: python3(Cheetah)
%endif

BuildRequires(pre): rpm-build-python3
BuildRequires: python3-module-sphinx
BuildRequires: python3-module-setuptools
BuildRequires: python3-module-wheel
%add_python3_req_skip new

%if_with bootstrap
%add_python3_req_skip paste.deploy paste.deploy.converters paste.translogger
%add_python3_req_skip paste.util paste.util.template paste.wsgilib
%endif

%if_without bootstrap
%py3_requires Cheetah
%endif

%description
A pluggable command-line frontend, including commands to setup
package file layouts.

%prep
%setup -n %oname-%version

%build
export PYTHONPATH=$PWD
sed -i 's|%_bindir/env python|%_bindir/env python3|' \
	tests/test_logging_config.py scripts/paster
sed -i 's|\(sphinx-build\)|\1-3|' regen-docs
%pyproject_build

./regen-docs

%install
%pyproject_install
mv %buildroot%_bindir/paster %buildroot%_bindir/paster3

%check
%pyproject_run_unittest discover tests -v

%files
%doc docs/_build/*
%python3_sitelibdir/paste/script
%python3_sitelibdir/%oname-%version-*-nspkg.pth
%python3_sitelibdir/%{pyproject_distinfo %oname}/
%_bindir/paster3

%changelog
