%define _unpackaged_files_terminate_build 1
%define pypi_name Levenshtein
%define mod_name %pypi_name

%def_with check

Name: python3-module-%pypi_name
Version: 0.27.1
Release: alt1

Summary: Python extension for computing string edit distances and similarities
License: GPL-2.0
Group: Development/Python3
Url: https://pypi.org/project/Levenshtein/
Vcs: https://github.com/rapidfuzz/Levenshtein

Source0: %name-%version.tar
Source1: %pyproject_deps_config_name
Patch0: %name-%version-alt.patch

%pyproject_runtimedeps_metadata
Provides: python3-module-%{pep503_name %pypi_name} = %EVR
BuildRequires(pre): rpm-build-pyproject

# For reason yet unknown, dependency on 'ninja>=1.5' is generated
# on most, platforms, but is not generated on loongarch64 and
# riscv64. In fact, the ninja module is not required for build
# the package, so let's just filter it out form all the stages
# including the verification of the generated dependencies.
%global _pyproject_deps_pep517_filter %_pyproject_deps_pep517_filter ninja

%add_pyproject_deps_build_filter cmake
%add_pyproject_deps_build_filter ninja
%pyproject_builddeps_build
BuildRequires: cmake
BuildRequires: gcc-c++
BuildRequires: rapidfuzz-cpp-devel
%if_with check
%pyproject_builddeps_metadata
%pyproject_builddeps_check
BuildRequires: python3-module-pytest
%endif

%description
The Levenshtein Python C extension module contains functions for fast
computation of

* Levenshtein (edit) distance, and edit operations
* string similarity
* approximate median strings, and generally string averaging
* string sequence and set similarity

It supports both normal and Unicode strings.

%prep
%setup
%autopatch -p1
%pyproject_deps_resync_build
%pyproject_deps_resync_metadata

%build
%ifarch %e2k
# standard is not specified, but rapidfuzz requires at least C++17
%add_optflags -std=c++17
%endif
%pyproject_build

%install
%pyproject_install

%check
%pyproject_run_pytest -vra

%files
%doc HISTORY.md README.md SECURITY.md
%python3_sitelibdir/%mod_name/
%python3_sitelibdir/%{pyproject_distinfo %pypi_name}/

%changelog
