# -*- rpm-spec -*-

%global optflags_lto %optflags_lto -ffat-lto-objects

%def_enable			static

%define real_name               python
Name: %real_name

Version: 2.7.18
Release: alt12

%define package_name		%real_name
%define weight			1001
%define suffix_ver		2.7
%define require_ver		2.7
%define python_name		%real_name%suffix_ver
%define __python_version	%suffix_ver
%define __python		%_builddir/Python-%version/python
%define nodot_ver		27
# When suffix_ver was removed from real_name
%define noversion_from		%suffix_ver-alt1

%def_with tk
%def_with ssl
%def_with bluez

%ifarch %ix86 x86_64
%def_with valgrind
%else
%def_without valgrind
%endif

%global _optlevel 3

Summary: An interpreted, interactive object-oriented programming language
License: Python-2.0
Group: Development/Python
URL: https://www.python.org/
Packager: Python Development Team <python@packages.altlinux.org>

# ftp://ftp.python.org/pub/python/%version/Python-%version.tar.bz2
Source: Python-%version.tar
#Source1: http://www.python.org/ftp/python/doc/%version/info-%version.tar.bz2
Source2: koi8_u.py
Source3: modules-list-%version.tar
Source8: pythonstart.py
Source9: python.sh
Source10: python.csh
Source11: pythonrc.py
Source12: bdist_altrpm.py
# test for CVE-2019-20907 fix
Source20: recursion.tar

Patch1: python-2.5.1-deb-setup.patch
Patch2: python-2.5.1-deb-distutils-link.patch
Patch3: python-2.5.1-alt-TextTools.patch
Patch4: python-2.6.5-alt-distutils-get_python_lib.patch
# use system libexpat library
Patch5: python-2.7.14-alt-expat.patch
# raise fatal error when extension fails to load
Patch6: python-2.5.1-alt-setup-PyBuildExt-raise.patch
# x64 build patches
Patch8: python-2.7.14-alt-lib64.patch
Patch9: python-2.7-lib64-sysconfig.patch
# add alt to the list of supported distribution
Patch10: python-2.6.2-detect-alt.patch
# add more constants to socketmodule
Patch16: python-2.7rc1-socketmodule-constants.patch
Patch17: python-2.7rc1-socketmodule-constants2.patch
Patch20: python-2.5.4-alt-python-config.patch
Patch21: python-2.6-ctypes-noexecmem.patch
Patch22: python-2.6.6-alt-bdist_altrpm.patch
Patch23: python-2.7.4-alt-linux2-platform.patch
Patch24: python-2.7.10-python-config-ldflags-alt.patch
Patch25: python2-platform-osrelease.patch
Patch26: python-ignore-env-trust-security.patch

# TODO: send upstream
Patch31: python-2.7.14-alt-test_resource-skip-impossible.patch
# TODO: a bug which needs a fix ignored for now
Patch32: python-2.7.14-alt-test_tuple-skip-bug.patch

Patch33: python-2.7.14-upstream-issue31530-patch1.patch
Patch34: python-2.7.14-upstream-issue31530-patch2.patch

# 00104 #
# Only used when "%_lib" == "lib64"
# Another lib64 fix, for distutils/tests/test_install.py; not upstream:
Patch104: 00104-lib64-fix-for-test_install.patch

Patch105: python-2.7.18-fc-alt-cve-2019-20907-fix-infinite-loop-in-tarfile.patch

# Reject control chars in HTTP method in httplib.putrequest to prevent
# HTTP header injection
#
# Backported from Python 3.5-3.10 (and adjusted for py2's single-module httplib):
# - https://bugs.python.org/issue39603
# - https://github.com/python/cpython/pull/18485 (3.10)
# - https://github.com/python/cpython/pull/21946 (3.5)
Patch106: python-2.7.18-fc-cve-2020-26116-http-request-method-crlf-injection-in-httplib.patch

# No longer call eval() on content received via HTTP in the CJK codec tests
# Backported from the python3 branches upstream: https://bugs.python.org/issue41944
# Resolves: https://bugzilla.redhat.com/show_bug.cgi?id=1889886
Patch107: python-2.7.18-fc-cve-2020-27619.patch

# CVE-2021-3177: Replace snprintf with Python unicode formatting in ctypes param reprs
#
# Backport of Python3 commit 916610ef90a0d0761f08747f7b0905541f0977c7:
# https://bugs.python.org/issue42938
# https://github.com/python/cpython/pull/24239
Patch108: python-2.7.18-fc-cve-2021-3177.patch

# CVE-2021-23336: Add `separator` argument to parse_qs; warn with default
#
# Partially backports https://bugs.python.org/issue42967 : [security] Address a web cache-poisning issue reported in urllib.parse.parse_qsl().
#
# Backported from the python3 branch.
# However, this solution is different than the upstream solution in Python 3.
#
# Based on the downstream solution for python 3.6.13 by Petr Viktorin.
#
# An optional argument seperator is added to specify the separator.
# It is recommended to set it to '&' or ';' to match the application or proxy in use.
# The default can be set with an env variable of a config file.
# If neither the argument, env var or config file specifies a separator, "&" is used
# but a warning is raised if parse_qs is used on input that contains ';'.
Patch109: python-2.7.18-fc-cve-2021-23336.patch

Patch110: python-2.7.18-fc-cve-2021-3733.patch
Patch111: python-2.7.18-fc-cve-2021-3737.patch
Patch112: python-2.7-fc-cve-2021-4189.patch
Patch113: python-2.7-fc-cve-2022-0391.patch
Patch114: python-2.7-fc-expat-2-4-5.patch
Patch115: python-2.7.18-fc-cve-2015-20107.patch
Patch116: python-2.7.18-fedora-openssl-3-compat.patch
Patch117: python-2.7.18-alt-openssl-3.1-compat.patch
Patch118: python-2.7.18-alt-backport-test_ftplib-fix.patch

# XXX ignore pydoc dependencies for now
%add_findreq_skiplist %_bindir/pydoc*
%add_python_req_skip msilib

# Ignore dependencies for Windows
%add_python_req_skip _winreg

# this package python = %version-%release requires all standard python modules
# package python = %require_ver is provided by python-strict and python-relaxed
Requires: python2-base
Requires: %name-modules %name-modules-encodings
Requires: %name-modules-curses %name-modules-xml %name-modules-compiler
Requires: %name-modules-email %name-modules-hotshot %name-modules-bsddb
Requires: %name-modules-logging

BuildPreReq: rpm >= 4.0.4-alt36.d8, rpm-build-python >= 0.34.4-alt1
# Automatically added by buildreq on Sun Apr 08 2007
BuildRequires: bzlib-devel gcc-c++ libdb4-devel libexpat-devel libgdbm-devel libncursesw-devel libreadline-devel libsqlite3-devel unzip zlib-devel libffi-devel
%{?_with_tk:BuildRequires: tk-devel}
%{?_with_valgrind:BuildRequires: valgrind-devel}
%{?_with_ssl:BuildRequires: libssl-devel}
%{?_with_bluez:BuildRequires: libbluez-devel}
%{?!_without_check:%{?!_disable_check:BuildPreReq: /proc /dev/pts}}

# NB:
# without_bootstrap might cut out quite a few packages;
# initial python build will still be a --nodeps affair,
# those interested are invited to have a closer look.
# -- mike@

%description
Python is an interpreted, interactive, object-oriented programming
language often compared to Tcl, Perl, Scheme or Java. Python includes
modules, classes, exceptions, very high level dynamic data types and
dynamic typing. Python supports interfaces to many system calls and
libraries, as well as to various windowing systems (X11, Motif, Tk,
Mac and MFC).

Programmers can write new built-in modules for Python in C or C++.
Python can be used as an extension language for applications that
need a programmable interface. This package contains most of the
standard Python modules, as well as modules for interfacing to the
Tix widget set for Tk and RPM.

Note that documentation for Python is provided in the python-docs
package.

%package strict
Summary: Python with strict conflicts: using other pythons are prohibited
Group: Development/Python
Requires: %name = %version-%release
Provides: %real_name = %require_ver
Conflicts: %name-relaxed
Conflicts: python24
Conflicts: python = 2.4
Conflicts: python23
Conflicts: python = 2.3
Obsoletes: %python_name-strict <= %noversion_from
BuildArch: noarch

%description strict
Python is an interpreted, interactive, object-oriented programming
language often compared to Tcl, Perl, Scheme or Java. Python includes
modules, classes, exceptions, very high level dynamic data types and
dynamic typing. Python supports interfaces to many system calls and
libraries, as well as to various windowing systems (X11, Motif, Tk,
Mac and MFC).

This is a python with strict conflicts: using other pythons are prohibited.

%package relaxed
Summary: Python with relaxed conflicts: using with python24 are allowed
Group: Development/Python
Requires: %name = %version-%release
Provides: %real_name = %require_ver
Conflicts: %name-strict
Obsoletes: %python_name-relaxed <= %noversion_from
BuildArch: noarch

%description relaxed
Python is an interpreted, interactive, object-oriented programming
language often compared to Tcl, Perl, Scheme or Java. Python includes
modules, classes, exceptions, very high level dynamic data types and
dynamic typing. Python supports interfaces to many system calls and
libraries, as well as to various windowing systems (X11, Motif, Tk,
Mac and MFC).

This is a python with relaxed conflicts: using with python24 are allowed.

%package -n python2-base
Summary: Base python modules and executables
Group: Development/Python
Provides: %python_libdir %python_dynlibdir %python_sitelibdir %python_tooldir
%if "lib" != "%_lib"
Provides: %prefix/lib/%python_name %prefix/lib/%python_name/site-packages %prefix/lib/%python_name/tools
%endif
Provides: %python_name(os.path)
Provides: %python_name(pwd)
Provides: python(abi) = %suffix_ver
Obsoletes: %python_name-base <= %noversion_from

%description -n python2-base
Python is an interpreted, interactive, object-oriented programming
language often compared to Tcl, Perl, Scheme or Java. Python includes
modules, classes, exceptions, very high level dynamic data types and
dynamic typing. Python supports interfaces to many system calls and
libraries, as well as to various windowing systems (X11, Motif, Tk,
Mac and MFC).

This package contains base python modules and executables.

%package modules
Summary: Standard python modules
Group: Development/Python
Requires: python2-base
Obsoletes: %python_name-modules <= %noversion_from
Obsoletes: %name-modules-nis < %version

%description modules
The Python programming language's interpreter can be extended with
dynamically loaded extensions and can be embedded in other programs.
This package contains the header files and libraries needed to do
these types of tasks.

Install this package if you want to develop Python extensions.  The
%name package will also need to be installed.  You'll probably also
want to install the python-docs package, which contains Python
documentation.

%package user-scripts
Summary: Python scripts for user improvements
Group: Development/Python
BuildArch: noarch
Requires: %name-modules = %version-%release

%description user-scripts
Python scripts for user improvements. Current release includes console
autocompletion based on readline for command line interface.

%package modules-distutils
Summary: Python "distutils" module
Group: Development/Python
# distutils used to be a part of python-dev:
Conflicts: %name-dev < 0:2.7.14-alt6
# To mitigate the absence of something after the separation, we should ensure
# that we install maximum Python minus python-dev (cf. python-dev's deps):
# (TODO: don't require extra stuff; however, I believe that
# patching the other specs for this is not a priority task.)
Requires: %name-modules = %version-%release
Requires: %name = %version-%release

%description modules-distutils
The "distutils" modules included with the Python distribution.

distutils are used when preparing Python packages for distribution,
but also at runtime by some Python libraries/executables.

%package modules-encodings
Summary: Python "encodings" module
Group: Development/Python
Requires: %name-modules = %version-%release
Obsoletes: %python_name-modules-encodings <= %noversion_from

%description modules-encodings
Standard Python encoding modules are provided by this package.

Codec modules have names corresponding to normalized encoding
names, e.g. 'utf-8' is implemented by the module 'utf_8.py'.

#%package obsolete
#Summary: Obsoleted python modules
#Group: Development/Python
#Requires: python2-base
#Obsoletes: %python_name-obsolete  <= %noversion_from
#
#%description obsolete
#Python is an interpreted, interactive, object-oriented programming
#language often compared to Tcl, Perl, Scheme or Java. Python includes
#modules, classes, exceptions, very high level dynamic data types and
#dynamic typing. Python supports interfaces to many system calls and
#libraries, as well as to various windowing systems (X11, Motif, Tk,
#Mac and MFC).
#
#This package contains obsolete python modules.

%package modules-curses
Summary: Python "curses" module
Group: Development/Python
Requires: python2-base
Obsoletes: %python_name-modules-curses

%description modules-curses
An interface to the curses library, providing portable terminal
handling. The Curses module provides an interface to the curses library, the
de-facto standard for portable advanced terminal handling.
This extension module is designed to match the API of ncurses, an
open-source curses library hosted on Linux and the BSD variants of UNIX.

%package modules-xml
Summary: Core XML support for Python
Group: Development/Python
Requires: %name-modules = %version-%release
Obsoletes: %python_name-modules-xml <= %noversion_from

%description modules-xml
This package contains three sub-packages:

dom -- The W3C Document Object Model.  This supports DOM Level 1 +
       Namespaces.

parsers -- Python wrappers for XML parsers (currently only supports Expat).

sax -- The Simple API for XML, developed by XML-Dev, led by David Megginson
       and ported to Python by Lars Marius Garshol.  This supports the SAX 2
       API.

%package modules-compiler
Summary: Package for parsing and compiling Python source code
Group: Development/Python
Requires: %name-modules = %version-%release
Obsoletes: %python_name-modules-compiler <= %noversion_from

%description modules-compiler
Python is an interpreted, interactive, object-oriented programming
language often compared to Tcl, Perl, Scheme or Java. Python includes
modules, classes, exceptions, very high level dynamic data types and
dynamic typing. Python supports interfaces to many system calls and
libraries, as well as to various windowing systems (X11, Motif, Tk,
Mac and MFC).

This is a package for parsing and compiling Python source code.

%package modules-email
Summary: A package for parsing, handling, and generating email messages
Group: Development/Python
Requires: %name-modules = %version-%release
Obsoletes: %python_name-modules-email <= %noversion_from

%description modules-email
Python is an interpreted, interactive, object-oriented programming
language often compared to Tcl, Perl, Scheme or Java. Python includes
modules, classes, exceptions, very high level dynamic data types and
dynamic typing. Python supports interfaces to many system calls and
libraries, as well as to various windowing systems (X11, Motif, Tk,
Mac and MFC).

This is a package for parsing, handling, and generating email messages.

%package modules-hotshot
Summary: High-perfomance logging profiler, mostly written in C
Group: Development/Python
Requires: %name-modules = %version-%release
Obsoletes: %python_name-modules-hotshot <= %noversion_from

%description modules-hotshot
Python is an interpreted, interactive, object-oriented programming
language often compared to Tcl, Perl, Scheme or Java. Python includes
modules, classes, exceptions, very high level dynamic data types and
dynamic typing. Python supports interfaces to many system calls and
libraries, as well as to various windowing systems (X11, Motif, Tk,
Mac and MFC).

This package contains high-perfomance logging profiler.

%package modules-bsddb
Summary: Support for BerkeleyDB 3.2 through 4.2
Group: Development/Python
Requires: %name-modules = %version-%release
Obsoletes: %python_name-modules-bsddb <= %noversion_from

%description modules-bsddb
Python is an interpreted, interactive, object-oriented programming
language often compared to Tcl, Perl, Scheme or Java. Python includes
modules, classes, exceptions, very high level dynamic data types and
dynamic typing. Python supports interfaces to many system calls and
libraries, as well as to various windowing systems (X11, Motif, Tk,
Mac and MFC).

This package contains BerkeleyDB support modules.

%package modules-ctypes
Summary: C libraries and data types wrapper helper for Python
Group: Development/Python
Requires: %name-modules = %version-%release
Obsoletes: %python_name-modules-ctypes <= %noversion_from, %python_name-module-ctypes <= %noversion_from
# ALT#18874
Provides: python-module-ctypes = %version-%release
Obsoletes: python-module-ctypes

%description modules-ctypes
ctypes is an advanced ffi (Foreign Function Interface) package for
Python 2.3 and higher.

ctypes allows to call functions exposed from dlls/shared libraries and
has extensive facilities to create, access and manipulate simple and
complicated C data types in Python - in other words: wrap libraries in
pure Python. It is even possible to implement C callback functions in
pure Python.

ctypes now includes a code generator toolchain which allows automatic
creation of library wrappers from C header files.

%package modules-wsgiref
Summary: WSGI Utilities and Reference Implementation
Group: Development/Python
Requires: %name-modules = %version-%release
Obsoletes: %python_name-modules-logging <= %noversion_from

%description modules-wsgiref
The Web Server Gateway Interface (WSGI) is a standard interface
between web server software and web applications written in Python.
Having a standard interface makes it easy to use an application
that supports WSGI with a number of different web servers.

Wsgiref is a reference implementation of the WSGI specification
that can be used to add WSGI support to a web server or framework.  It
provides utilities for manipulating WSGI environment variables and
response headers, base classes for implementing WSGI servers, a demo
HTTP server that serves WSGI applications, and a validation tool that
checks WSGI servers and applications for conformance to the
WSGI specification PEP 333.

%package modules-sqlite3
Summary: DB-API 2.0 interface for SQLite databases
Group: Development/Python
Requires: %name-modules = %version-%release
Obsoletes: %python_name-modules-logging <= %noversion_from

%description modules-sqlite3
SQLite is a C library that provides a lightweight disk-based database
that doesn't require a separate server process and allows accessing
the database using a nonstandard variant of the SQL query language.
Some applications can use SQLite for internal data storage.  It's also
possible to prototype an application using SQLite and then port the
code to a larger database such as PostgreSQL or Oracle.

pysqlite was written by Gerhard Ha:ring and provides a SQL interface
compliant with the DB-API 2.0 specification described by PEP 249.

%package modules-logging
Summary: Logging package for Python
Group: Development/Python
Requires: %name-modules = %version-%release
Requires: %name-modules-multiprocessing
Obsoletes: %python_name-modules-logging <= %noversion_from

%description modules-logging
Logging package for Python. Based on PEP 282 and comments thereto in
comp.lang.python, and influenced by Apache's log4j system.

%package modules-unittest
Summary: Unit testing framework for Python
Group: Development/Python
Requires: %name-modules = %version-%release

%description modules-unittest
Unit testing framawork for Python. The Python unit testing framework,
sometimes referred to as "PyUnit," is a Python language version of JUnit,
by Kent Beck and Erich Gamma.Based on PEP 282 and comments thereto in
comp.lang.python, and influenced by Apache's log4j system.

%package dev
Summary: The libraries and header files needed for Python development
Group: Development/Python
Requires: %name-modules = %version-%release
Requires: %name-modules-distutils = %version-%release
Requires: %name = %version-%release
Requires: rpm-build-python
Provides: %real_name-devel = %require_ver
Obsoletes: %python_name-modules-dev <= %noversion_from
Provides: lib%name-devel = %version-%release

%description dev
The Python programming language's interpreter can be extended with
dynamically loaded extensions and can be embedded in other programs.
This package contains the header files and libraries needed to do
these types of tasks.

Install this package if you want to develop Python extensions.  The
%name package will also need to be installed.  You'll probably also
want to install the python-docs package, which contains Python
documentation.

%package -n libpython
Summary: Python shared library
Group: Development/Python

%description -n libpython
This package contains Python3 shared library

%package test
Summary: Test suite for standard python modules
Group: Development/Python
Requires: python2-base
AutoReqProv: yes, nopython
Obsoletes: %python_name-test <= %noversion_from

%description test
Python is an interpreted, interactive, object-oriented programming
language often compared to Tcl, Perl, Scheme or Java. Python includes
modules, classes, exceptions, very high level dynamic data types and
dynamic typing. Python supports interfaces to many system calls and
libraries, as well as to various windowing systems (X11, Motif, Tk,
Mac and MFC).

This package contains test suite for standard python modules.

%package tools-i18n
Summary: Scripts to provide i18n support for developers
Group: Development/Python
Requires: %name-modules-compiler = %version-%release
Obsoletes: %python_name-tools-i18n <= %noversion_from

%description tools-i18n
Package provide pygettext and pymsgfmt scripts.
pygettext uses Python's standard tokenize module to scan
Python source code, generating .pot files identical to what GNU xgettext
generates for C and C++ code.

%package tools-webchecker
Summary: This is a simple web tree checker
Group: Development/Python
Requires: %name-modules-email = %version-%release
Requires: %name-modules-tkinter = %version-%release
Obsoletes: %python_name-tools-webchecker <= %noversion_from

%description tools-webchecker
This is a simple web tree checker, useful to find bad links in a web
tree.  It currently checks links pointing within the same subweb for
validity.  The main program is "webchecker.py".  Invoke it with the
option "-?") for more defails.

%package tools-pynche
Summary: The PYthonically Natural Color and Hue Editor
Group: Development/Python
Requires: %name-modules-tkinter = %version-%release
Obsoletes: %python_name-tools-pynche <= %noversion_from

%description tools-pynche
Pynche is a color editor based largely on a similar program that I
originally wrote back in 1987 for the Sunview window system.  That editor
was called ICE, the Interactive Color Editor.  I'd always wanted to port
this program to X but didn't feel like hacking X and C code to do it.  Fast
forward many years, to where Python + Tkinter provides such a nice
programming environment, with enough power, that I finally buckled down and
re-implemented it.  I changed the name because these days, too many other
systems have the acronym CE'.

%package tools-idle
Summary: An Integrated Development Environment for Python
Group: Development/Python
Requires: %name-modules-compiler = %version-%release
Requires: %name-modules-tkinter = %version-%release
Obsoletes: %python_name-tools-idle <= %noversion_from

%description tools-idle
IDLE is a basic editor and interpreter environment that ships with the
standard distribution of Python.  Good for beginners, it also serves as
clear example code for those wanting to implement a moderately
sophisticated, multi-platform GUI application.

%package tools-scripts
Summary: A collection of executable Python scripts from main distribution
Group: Development/Python
Requires: %name-modules-compiler = %version-%release
Requires: %name-modules-email = %version-%release
Requires: %name-modules-hotshot = %version-%release
Requires: %name-modules-tkinter = %version-%release
Requires: %name-dev = %version-%release
%py_requires mx.TextTools
Obsoletes: %python_name-scripts-idle <= %noversion_from

%description tools-scripts
This package contains a collection of executable Python scripts that
are useful while building, extending or managing Python.  Some (e.g.,
dutree or lll) are also generally useful UNIX tools.

%package tools-2to3
Summary: Automated Python 2 to 3 code translator
Group: Development/Python
Requires: %name-modules-logging = %version-%release

%description tools-2to3
This package contains utility for automated Python 2 to 3 code translation.
2to3 is a Python program that reads Python 2.x source code and applies a series
of fixers to transform it into valid Python 3.x code.

%package tools-smtpd
Summary: An RFC 2821 smtp proxy
Group: Development/Python
BuildArch: noarch

%description tools-smtpd
This file implements the minimal SMTP protocol as defined in RFC 821.  It
has a hierarchy of classes which implement the backend functionality for the
smtpd.  A number of classes are provided:
SMTPServer - the base class for the backend.  Raises NotImplementedError
if you try to use it.
DebuggingServer - simply prints each message it receives on stdout.
PureProxy - Proxies all messages to a real smtpd which does final delivery.
MailmanProxy - An experimental hack to work with GNU Mailman <www.list.org>.

%package modules-tkinter
Summary: A graphical user interface for the Python scripting language
Group: Development/Python
Requires: %name-modules = %version-%release
Requires: tk
Provides: tkinter = %require_ver

Obsoletes: %python_name-modules-tkinter <= %noversion_from

%description modules-tkinter
The Tkinter (Tk interface) program is an graphical user interface for
the Python scripting language.

You should install this package if you'd like to use a graphical
user interface for Python programming.

%package modules-json
Summary: Python JSON encoder and decoder
Group: Development/Python
Requires: %name-modules = %version-%release
Provides: python-module-json
Obsoletes: python-module-json

%description modules-json
JSON (JavaScript Object Notation) is a subset of JavaScript syntax
(ECMA-262 3rd edition) used as a lightweight data interchange format.

%package modules-multiprocessing
Summary: Process-based threading interface for Python
Group: Development/Python
Requires: %name-modules-ctypes = %version-%release
Requires: %name-modules-email = %version-%release

%description modules-multiprocessing
This package supports spawning processes using an API similar to the
threading module. The multiprocessing package offers both local and
remote concurrency, effectively side-stepping the Global Interpreter
Lock by using subprocesses instead of threads. Due to this, the
multiprocessing module allows the programmer to fully leverage multiple
processors on a given machine.

%package modules-ensurepip
Summary: Bootstrapping the pip installer
Group: Development/Python
Requires: %name-modules = %version-%release

%description modules-ensurepip
The ensurepip package provides support for bootstrapping the pip
installer into an existing Python installation or virtual environment.

#%package info
#Summary: Info documentation for the Python scripting language
#Group: Development/Python
#
#Obsoletes: %python_name-info <= %noversion_from
#
#%description info
#This archive contains the standard Python documentation in GNU info
#format.  Thanks go to Milan Zamazal <pdm@zamazal.org> for providing this
#conversion to the info format.
#
#Questions and comments on these documents should be directed to
#docs@python.org.

%package devel-static
Summary: Static python library for products with embeded python
Group: Development/Python

Obsoletes: %python_name-devel-static <= %noversion_from

%description devel-static
Python provides two kind of python-library to build application with
embedded-python capability. Using of shared library is preffered and
static library is obsoleted. This package are content static library and
intend only for some stupid application (configure scripts?) that can't
be linked with shared library.

%add_findreq_skiplist %python_tooldir/parseentities.py

%prep
%setup -q -n Python-%version
# fix shebangs
find . -type f -exec sed -Ei '1 s@(^#!.*/usr/bin/).*python$@\1%python_name@' '{}' '+'
%undefine _python_compile_skip_x
#mkdir info
#tar -C info -xf #SOURCE1
tar -xf %SOURCE3
cp -a -- %SOURCE20 Lib/test/recursion.tar

rm -r Modules/expat

%patch1 -p2
%patch2 -p1
%patch3 -p1
%patch4 -p1
%patch5 -p1
%patch6 -p1

%if "lib" != "%_lib"
%patch8 -p1
%patch9 -p1
%patch104 -p1
# TODO: adapt our package to other %%_lib like this:
# < %PATCH104 sed -e 's:lib64:%_lib:g' | patch -p1
%endif

%patch10 -p1
%patch16 -p1
%patch17 -p1
%patch20 -p1
#Fix SELinux execmem problems from Fedora
#This patch ffi_closure_free() implementation needs
#patch21 -p1
%patch22 -p2
install -p -m644 %SOURCE12 -t Lib/distutils/command
%patch23 -p1
%patch24 -p2
%patch25 -p1
%patch26 -p1

%patch31 -p2
#patch32 -p2

##patch33 -p1
##patch34 -p1
%patch105 -p2
%patch106 -p1
%patch107 -p1
%patch108 -p1
%patch109 -p1
%patch110 -p1
%patch111 -p1
%patch112 -p1
%patch113 -p1
%patch114 -p1
%patch115 -p1
%patch116 -p1
%patch117 -p1
%patch118 -p1

# XXX temporary Issue20445 fix
sed -i 's/val1 == nice(2)/val1 == nice(2)+2/' configure.ac

find -type f \( -name \*~ -o -name \*.orig \) -print0 |
	xargs -r0 rm -f --

find -type f -print0 |
    xargs -r0 grep -FZl -- /usr/local/bin/python |
    xargs -r0 sed -i 's@/usr/local/bin/python@/usr/bin/%python_name@' --

xz -9k Misc/{HISTORY,NEWS,cheatsheet}

%build
rm -rf ../build-static
mkdir -p ../build-static
export OPT="$RPM_OPT_FLAGS -fwrapv"
libtoolize --copy --force
autoconf
##cp -rl * ../build-static/

build () {
_Target="$1"
shift
%ifarch %e2k
cc --version | grep -q '^lcc:1.21' && export LIBS+="-lcxa"
%endif
%configure \
	--with-threads \
	%{subst_with valgrind} \
	%{subst_with tk} \
	--with-system-ffi \
	--with-system-expat \
	--with-libs="$LIBS" \
	--enable-ipv6 \
	%{subst_enable static} \
	$*

%make_build LDFLAGS="-L$PWD" $_Target
}

#pushd ../build-static
##build python
#build all
#popd

build all --enable-shared

#bzip2 info/python*info*
#cat > info/python%nodot_ver.dir <<EOF
#INFO-DIR-SECTION Development/Python
#START-INFO-DIR-ENTRY
#EOF
#cat info/python.dir >> info/python%nodot_ver.dir
#cat >> info/python%nodot_ver.dir <<EOF
#END-INFO-DIR-ENTRY
#EOF

%check
# -l (to find memory leaks) is not compatible with -j...
# Therefore, we reset TESTOPTS (which includes -l by default)
# instead of adding EXTRATESTOPTS.
LC_ALL=C.UTF-8 make test TESTOPTS="-v %_smp_mflags"

%install
rln()
{
	local target=$1; shift
	local source=$1; shift
	target="$(relative "$target" "$source")"
	ln -snf "$target" "%buildroot$source"
}

mkdir -p %buildroot%_mandir
#mkdir -p %buildroot%_infodir
mkdir -p %buildroot%prefix/lib/%python_name/{site-packages,tools}
#install info/python*bz2 info/python%nodot_ver.dir %buildroot%_infodir

#  set the install path
echo '[install_scripts]' >setup.cfg
echo 'install_dir='"%buildroot%_bindir" >>setup.cfg

export LD_LIBRARY_PATH=%buildroot%_libexecdir:$LD_LIBRARY_PATH

makeinstall() {
%make \
	DESTDIR=%buildroot \
	BINDIR=%_bindir \
	LIBDIR=%_libdir \
	MANDIR=%_mandir \
	INCLUDEDIR=%_includedir \
	"$@"
install %SOURCE2 %buildroot%python_libdir/encodings
}

makeinstall install

##pushd ../build-static
##makeinstall bininstall
##popd

mv %buildroot%python_libdir/config/lib%python_name.a %buildroot%_libdir/lib%python_name.a

# cray : hack for hotshot
rm %buildroot%python_libdir/hotshot/stones.py*

# hack for pydoc
mv %buildroot%_bindir/pydoc %buildroot%_bindir/pydoc%suffix_ver

# prepare python-config and python.pc files for alternatives
rm %buildroot%_bindir/python-config %buildroot%_pkgconfigdir/python.pc

# idle
cat <<EOF >%buildroot%python_libdir/idlelib/idle - %buildroot%python_libdir/idlelib/idle.py
#! /usr/bin/%python_name
EOF

rln %python_libdir/idlelib/idle %_bindir/idle%suffix_ver
chmod +x %buildroot%python_libdir/idlelib/idle

mkdir -p %buildroot%python_tooldir

# pynche
rm -f Tools/pynche/*.pyw
cp -r Tools/pynche %buildroot%python_tooldir/
rln %python_tooldir/pynche/pynche %_bindir/pynche%suffix_ver

cp Tools/i18n/*.py %buildroot%python_tooldir/
rln %python_tooldir/pygettext.py %_bindir/pygettext
rln %python_tooldir/msgfmt.py %_bindir/pymsgfmt

cp -r Tools/webchecker/ %buildroot%python_tooldir/
for item in wcgui.py webchecker.py  websucker.py  wsgui.py; do
   rln %python_tooldir/webchecker/$item %_bindir/$(basename $item .py) #%%dirver
done

ln -f Tools/pynche/README Tools/pynche/README.pynche

# Tools/scripts
install -m 755 Tools/scripts/*.py %buildroot%python_tooldir/
rm -f %buildroot%python_tooldir/byext.py
( cd Tools/scripts; ls *.py ) | grep -v "byext.py" | sed 's@^@%python_tooldir/@;p;s/$/o/p;s/o$/c/' > .TOOLS_SCRIPTS

rm -f modules-list.full
for n in %buildroot%python_libdir/*; do
  [ -d "$n" ] || echo "$n"
done >> modules-list.full

echo >modules-exclude
for list in modules-list/*-list modules-list/base-list; do
    name=$(basename $list).tmp
    cat $list >$name
    grep "py$" $list|sed "s|.*|&c|g" >>$name
    grep "py$" $list|sed "s|.*|&o|g" >>$name
    sed <$name -e "s|^[^#]|%python_libdir/&|g"|tee $(basename $list)
done | sort  > modules-exclude

for mod in %buildroot%python_libdir/lib-dynload/*; do
  [ `basename $mod` = _tkinter.so ] || echo "$mod"
done >> modules-list.full
sed "s|%buildroot||g" <modules-list.full |sort|comm -23 - modules-exclude >other-list

# menu support
mkdir -p %buildroot%_menudir
cat > %buildroot%_menudir/idle%version << EOF
#?package(%real_name): needs=text section="Applications/Development/Interpreters" title=Python command=python
#?package(%name-tools-idle): needs="gnome" section="Applications/Development/Development environments" title="IDLE" \
longtitle="IDE for Python %version" command="NO_XALF %_bindir/idle" icon="development_section.xpm"
?package(%name-tools-idle): needs=x11 section="Applications/Development/Development environments" title="IDLE" \
longtitle="IDE for Python %version" command="%_bindir/idle" icon="development_section.xpm"
EOF

chmod -x %buildroot%python_libdir/test/*.py*

find %buildroot -type f -print0 |
	xargs -r0 grep -FZl -- %buildroot |
	xargs -r0 sed -i 's|%buildroot||g' --

touch dev-list
mkdir -p %buildroot%_sysconfdir/buildreqs/packages/substitute.d
if [ "%real_name" != "%name" ]; then
echo %real_name >%buildroot%_sysconfdir/buildreqs/packages/substitute.d/%name
echo %_sysconfdir/buildreqs/packages/substitute.d/%name >> base-list
echo %real_name-devel >%buildroot%_sysconfdir/buildreqs/packages/substitute.d/%name-devel
echo %_sysconfdir/buildreqs/packages/substitute.d/%name-devel >> dev-list
fi
echo %real_name-devel >%buildroot%_sysconfdir/buildreqs/packages/substitute.d/%name-dev
%if_with tk
echo tkinter >%buildroot%_sysconfdir/buildreqs/packages/substitute.d/%python_name-modules-tkinter
%endif
chmod 644 %buildroot%_sysconfdir/buildreqs/packages/substitute.d/*

%global python_ignored_files site-packages(/.+\\.(pth|egg-info(|/entry_points\\.txt|/namespace_packages\\.txt)))?$
mkdir -p %buildroot%_sysconfdir/buildreqs/files/ignore.d
cat > %buildroot%_sysconfdir/buildreqs/files/ignore.d/%name << EOF
^%_libdir/python[^/]*/%python_ignored_files
%if "lib" != "%_lib"
^%prefix/lib/python[^/]*/%python_ignored_files
%endif
EOF

cat >> python.sh <<EOF
#! /bin/bash
export LD_LIBRARY_PATH=%_builddir/Python-%version
%_builddir/Python-%version/python "\$@"
EOF
chmod +x python.sh

%define __python %_builddir/Python-%version/python.sh
%define _python_lib_path %(RPM_BUILD_ROOT=%buildroot LD_LIBRARY_PATH=%buildroot%_libdir %buildroot%_bindir/%python_name -c "import sys,os; path=os.path.normpath(os.environ['RPM_BUILD_ROOT']) ; print ' '.join([ x[len(path):] for x in [ os.path.normpath(x) for x in sys.path] if x[0:len(path)]==path])")
%add_python_req_skip bundlebuilder

# startup user script
install -m 644 %SOURCE8 %buildroot%_sysconfdir
install -d -m 755 %buildroot%_sysconfdir/profile.d
install -m 755 %SOURCE9 %SOURCE10 %buildroot%_sysconfdir/profile.d
install -d -m 755 %buildroot%_sysconfdir/skel
install -m 644 %SOURCE11 %buildroot%_sysconfdir/skel/.pythonrc.py

mkdir -p %buildroot%_rpmlibdir
cat <<\EOF >%buildroot%_rpmlibdir/python2-base-files.req.list
# python2-base dirlist for %_rpmlibdir/files.req
%python_libdir	python2-base
%python_dynlibdir	python2-base
%python_sitelibdir	python2-base
%python_tooldir	python2-base
EOF
%if "lib" != "%_lib"
cat <<\EOF >>%buildroot%_rpmlibdir/python2-base-files.req.list
%prefix/lib/%python_name	python2-base
%prefix/lib/%python_name/site-packages	python2-base
%prefix/lib/%python_name/tools	python2-base
EOF
%endif

ln -s %python_name-config %buildroot%_bindir/python-config
ln -s pydoc%suffix_ver %buildroot%_bindir/pydoc
ln -s python-%suffix_ver.pc %buildroot%_pkgconfigdir/%real_name.pc

ln -sf idle%suffix_ver %buildroot%_bindir/idle
ln -s pynche%suffix_ver %buildroot%_bindir/pynche

rm -rf %buildroot%_libdir/%python_name/lib2to3/tests/
rm %buildroot%_bindir/python
rm %buildroot%_man1dir/python.1

%define _unpackaged_files_terminate_build 1
%define _stripped_files_terminate_build 1

%files

%files strict

%files relaxed

%files -n python2-base -f base-list
%_mandir/man?/*
%config %_sysconfdir/buildreqs/files/ignore.d/%name
%_bindir/%python_name
%_bindir/%{real_name}2
%_bindir/pydoc
%_bindir/pydoc%suffix_ver
%dir %python_libdir
%dir %python_dynlibdir
%dir %python_sitelibdir
%dir %python_tooldir
%doc LICENSE
%doc Misc/{HISTORY,NEWS,cheatsheet}.xz
%if "lib" != "%_lib"
%prefix/lib/%python_name
%endif
%_rpmlibdir/python2-base-files.req.list
%python_libdir/pydoc_data
%python_libdir/importlib
%python_libdir/config
%python_sitelibdir/README
%_includedir/%python_name/pyconfig.h
%dir %_includedir/%python_name

%files -n libpython
%_libdir/lib%python_name.so.*

%files user-scripts
%_sysconfdir/pythonstart.py
%_sysconfdir/skel/.pythonrc.py
%_sysconfdir/profile.d/*

%files modules -f other-list
%python_libdir/plat-linux2
%exclude %python_libdir/wsgiref.egg-info

%files modules-curses -f modules-curses-list
%python_libdir/curses

%files modules-xml -f modules-xml-list
%python_libdir/xml

%files modules-compiler -f modules-compiler-list
%python_libdir/compiler

%files modules-email -f modules-email-list
%dir %python_libdir/email
%python_libdir/email/*py
%python_libdir/email/*pyc
%python_libdir/email/*pyo
%python_libdir/email/mime

%files modules-hotshot -f modules-hotshot-list
%python_libdir/hotshot

%files modules-bsddb -f modules-bsddb-list
%dir %python_libdir/bsddb
%python_libdir/bsddb/*py
%python_libdir/bsddb/*pyc
%python_libdir/bsddb/*pyo

%files modules-ctypes -f modules-ctypes-list
%dir %python_libdir/ctypes
%python_libdir/ctypes/*.py
%python_libdir/ctypes/*.py?
%python_libdir/ctypes/macholib
%exclude %python_libdir/ctypes/macholib/fetch_macholib*

%files modules-wsgiref
%python_libdir/wsgiref
%python_libdir/wsgiref.egg-info

%files modules-sqlite3 -f modules-sqlite3-list
%dir %python_libdir/sqlite3
%python_libdir/sqlite3/*.py
%python_libdir/sqlite3/*.py?

%files modules-logging -f modules-logging-list
%python_libdir/logging

%files modules-unittest -f modules-unittest-list
%python_libdir/unittest

%files modules-distutils -f modules-distutils-list
%python_libdir/distutils
%exclude %python_libdir/distutils/tests

%files modules-encodings -f modules-encodings-list
%python_libdir/encodings

%files modules-json -f modules-json-list
%python_libdir/json
%exclude %python_libdir/json/tests

%files modules-multiprocessing -f modules-multiprocessing-list
%python_libdir/multiprocessing

%files modules-ensurepip
%exclude %python_libdir/ensurepip/_bundled
%python_libdir/ensurepip/*py
%python_libdir/ensurepip/*pyc
%python_libdir/ensurepip/*pyo

#%files obsolete
#%python_libdir/lib-old

# some tools R: p-m-tkinter
%if_with tk
%files tools-idle
%python_libdir/idlelib
%exclude %python_libdir/idlelib/idle_test/
%_bindir/idle
%_bindir/idle%suffix_ver
%exclude %_bindir/idle
%doc Lib/idlelib/README.txt Lib/idlelib/NEWS.txt Lib/idlelib/HISTORY.txt Lib/idlelib/CREDITS.txt
%_menudir/idle%version
%endif

%files tools-2to3
%python_libdir/lib2to3
%_bindir/2to3

%if_with tk
%files tools-pynche
%python_tooldir/pynche
%_bindir/pynche
%_bindir/pynche%suffix_ver
%doc Tools/pynche/README
%endif

%files tools-i18n
%python_tooldir/pygettext.py*
%python_tooldir/msgfmt.py*
%python_tooldir/makelocalealias.py*
%_bindir/pygettext
%_bindir/pymsgfmt

%if_with tk
%files tools-webchecker
%python_tooldir/webchecker/*.py*
%exclude %python_tooldir/webchecker/README
%_bindir/wcgui
%_bindir/webchecker
%_bindir/websucker
%_bindir/wsgui
%doc Tools/webchecker/README
%endif

%files tools-smtpd
%_bindir/smtpd.py

%if_with tk
%files tools-scripts -f .TOOLS_SCRIPTS
%doc Tools/scripts/README Tools/scripts/dutree.doc
%endif

%files dev -f dev-list
%config %_sysconfdir/buildreqs/packages/substitute.d/%name-dev
%_includedir/%python_name
%exclude %_includedir/%python_name/pyconfig.h
%_libdir/lib%python_name.so
%_pkgconfigdir/python.pc
%_pkgconfigdir/python2.pc
%_pkgconfigdir/python-%suffix_ver.pc
%_bindir/%python_name-config
%_bindir/python-config
%_bindir/python2-config

%files test
%python_libdir/test
%python_libdir/ctypes/test
%python_libdir/sqlite3/test
%python_libdir/email/test
%python_libdir/bsddb/test
%python_libdir/distutils/tests

#%files info
#/usr/share/info/*
#%doc Lib/*.doc
#%doc PQR%suffix_ver.pdf PQR%suffix_ver/*

%if_enabled static
%files devel-static
%_libdir/lib%python_name.a
%endif

%if_with tk
%files modules-tkinter
%config %_sysconfdir/buildreqs/packages/substitute.d/%python_name-modules-tkinter
%python_libdir/lib-tk
%exclude %python_libdir/lib-tk/test
%python_libdir/lib-dynload/_tkinter.so
%endif

%changelog
