Name: pycrc
Version: 0.9.2
Release: alt1

Summary: A parametrizable Cyclic Redundancy Check (CRC) calculation utility and C source code generator written in Python

Url: https://pycrc.org/
License: BSD like
Group: Development/Python

BuildArch: noarch

Packager: Vitaly Lipatov <lav@altlinux.ru>

# Source-url: https://github.com/tpircher/pycrc/archive/v%version.tar.gz
Source: %name-%version.tar

BuildRequires(pre): rpm-build-python3

%description
Pycrc provides a CRC reference implementation in Python and a source
code generator for C. The used CRC variant can be chosen from a fast
but space-consuming implementation to slower but smaller implementations
suitable especially for embedded applications. The following functions
are implemented:
 * generate the checksum of a string  
 * generate the C header and source files for a client implementation. The
   algorithm can be chosen from fast but big implementation to slower but
   smaller implementations suitable especially for embedded applications.

%prep
%setup
%__subst "s|^#!/usr/bin/env python$|#!/usr/bin/python3|" *.py

%build
%python3_build
# TODO: need saxon-xslt
#make -C doc

%install
#python3_install
install -m755 -D %name.py %buildroot%_bindir/%name
#install -m644 -D doc/%name.1 %buildroot%_man1dir/%name.1
mkdir -p %buildroot%python3_sitelibdir/pycrc/
install -m644 pycrc/*.py %buildroot%python3_sitelibdir/pycrc/

%files
#doc doc/pycrc.html
%doc CHANGELOG.md README.md COPYING
%_bindir/%name
#_man1dir/*
%python3_sitelibdir/*

%changelog
