%define _unpackaged_files_terminate_build 1

%def_with check

Name: pybind11
Version: 3.0.1
Release: alt1

Summary: Seamless operability between C++11 and Python
License: BSD-3-Clause
Group: Development/Other

Url: https://github.com/pybind/pybind11
Source: %name-%version.tar

BuildArch: noarch

BuildRequires(pre): rpm-macros-cmake
BuildRequires(pre): rpm-build-python3
BuildRequires: boost-devel
BuildRequires: catch-devel
BuildRequires: ccmake
BuildRequires: cmake
BuildRequires: eigen3
BuildRequires: gcc-c++
BuildRequires: python3-module-scikit-build-core

# These are only needed for the checks
%if_with check
BuildRequires: python3-module-pytest
BuildRequires: python3-module-numpy
BuildRequires: python3-module-numpy-testing
BuildRequires: python3-module-scipy
BuildRequires: eigen3-devel
BuildRequires: ctest
%endif

%package devel
Summary: %summary
Group: Development/Other
# For dir ownership
Requires: cmake

%package -n python3-module-%name
Summary: %summary
Group: Development/Python3
Requires: %name-devel = %EVR

%define base_description \
pybind11 is a lightweight header-only library that exposes C++ types in Python and vice versa, mainly to create Python bindings of existing C++ code. Tutorial and reference documentation is provided at http://pybind11.readthedocs.org/en/master

%description
%base_description

%description devel
%base_description

This package contains the development headers for pybind11.

%description -n python3-module-%name
%base_description

This package contains the Python 3 files.

%prep
%setup

# Dropped dependency on distutils (for python3.12)
sed -i 's/distutils.ccompiler/setuptools._distutils.ccompiler/' pybind11/setup_helpers.py
sed -i 's/distutils.errors/setuptools._distutils.errors/' pybind11/setup_helpers.py

%build
%pyproject_build
%cmake \
	-DCMAKE_BUILD_TYPE=Release \
	-DPYBIND11_TEST=ON \
	-DPYTHON_EXECUTABLE=%_bindir/python3
%cmake_build

%install
%pyproject_install
%cmake_install

# remove duplicated header files from sitelibs but link to common dirs as some
# packages expect them to be in the sitelib where pybind11.get_include() reports them.
rm -rf %buildroot%python3_sitelibdir/pybind11/include/pybind11
ln -s %_includedir/pybind11 %buildroot%python3_sitelibdir/pybind11/include/pybind11
# same for cmake files: pybind11.get_cmake_dir()
rm -r %buildroot%python3_sitelibdir/pybind11/share/cmake/pybind11
ln -s %_datadir/cmake/pybind11 %buildroot%python3_sitelibdir/pybind11/share/cmake/pybind11
# same for pkgconfig
rm %buildroot%python3_sitelibdir/pybind11/share/pkgconfig/pybind11.pc
ln -s %_datadir/pkgconfig/pybind11.pc %buildroot%python3_sitelibdir/pybind11/share/pkgconfig/pybind11.pc

%check
%ifarch %e2k
export SKIP_E2K=1
%endif
export PYTHONPATH=$PWD/noarch-alt-linux/tests
ignore_tests="--ignore tests/test_embed/test_interpreter.py --ignore tests/test_embed/test_trampoline.py"
ignore_tests="$ignore_tests --ignore tests/extra_python_package/test_files.py"
py.test-3 $ignore_tests

%files devel
%doc README.rst LICENSE docs/*
%_includedir/%name
%_datadir/cmake/%name
%_bindir/%name-config
%_datadir/pkgconfig/%name.pc

%files -n python3-module-%name
%python3_sitelibdir/%name
%python3_sitelibdir/%name-%version.dist-info

%changelog
