%global optflags_lto %nil
%define _unpackaged_files_terminate_build 1
%define rname qemu
%define _group vmusers
%define _libexecdir /usr/libexec
%define _localstatedir /var
%global firmwaredirs "%_datadir/qemu:%_datadir/seabios:%_datadir/seavgabios:%_datadir/ipxe:%_datadir/ipxe.efi"

%ifarch %ix86 x86_64
%def_enable have_vmsr_helper
%else
%def_disable have_vmsr_helper
%endif

Name: pve-%rname
Version: 10.1.2
Release: alt1
Epoch: 1
Summary: QEMU CPU Emulator
License: BSD-2-Clause AND BSD-3-Clause AND GPL-2.0-only AND GPL-2.0-or-later AND LGPL-2.1-or-later AND MIT
Group: Emulators
URL: http://www.nongnu.org/qemu/

Source0: %name-%version.tar
Source99: debian.tar
Source100: keycodemapdb.tar
Source101: berkeley-testfloat-3.tar
Source102: berkeley-softfloat-3.tar
# qemu-kvm back compat wrapper
Source5: qemu-kvm.sh
# /etc/qemu/bridge.conf
Source12: bridge.conf
Source13: vitastor.c

Patch: pve-qemu-10.1-vitastor.patch
%set_verify_elf_method fhs=relaxed
%add_verify_elf_skiplist %_datadir/%rname/*
%add_findreq_skiplist %_datadir/%rname/*
%add_findreq_skiplist %_datadir/pve-edk2-firmware/*

ExclusiveArch: x86_64 aarch64

Requires: %name-system = %EVR %name-img = %EVR
Conflicts: %rname
Provides: pve-qemu-kvm = %EVR

BuildRequires: acpica bzlib-devel glib2-devel flex libacl-devel libaio-devel libalsa-devel libattr-devel libcap-devel
BuildRequires: libcap-ng-devel libcurl-devel libfdt-devel libgnutls-devel libiscsi-devel libjpeg-devel
BuildRequires: liblzo2-devel libncurses-devel libnettle-devel libnuma-devel libpci-devel libpixman-devel libpng-devel ceph-devel
BuildRequires: libsasl2-devel libseccomp-devel libspice-server-devel libusbredir-devel libxfs-devel libepoxy-devel libgbm-devel
BuildRequires: makeinfo perl-Pod-Usage pkgconfig(virglrenderer) liburing-devel libuuid-devel
BuildRequires: libslirp-devel >= 4.7.0
BuildRequires: libsystemd-devel libudev-devel libtasn1-devel libpmem-devel libzstd-devel zlib-devel spice-protocol
BuildRequires: ipxe-roms-qemu seavgabios seabios edk2-ovmf edk2-aarch64 qboot
BuildRequires: rdma-core-devel
BuildRequires: python3-module-sphinx python3-module-sphinx_rtd_theme ninja-build meson
BuildRequires: python3-module-setuptools
BuildRequires: libproxmox-backup-qemu-devel >= 1.3.0
BuildRequires: libvitastor-devel
BuildRequires: perl(JSON.pm)

%description
QEMU is a fast processor emulator using dynamic translation to achieve
good emulation speed.  QEMU has two operating modes:

* Full system emulation.  In this mode, QEMU emulates a full system
  (for example a PC), including a processor and various peripherials.
  It can be used to launch different Operating Systems without rebooting
  the PC or to debug system code.

* User mode emulation.  In this mode, QEMU can launch Linux processes
  compiled for one CPU on another CPU.  It can be used to launch the
  Wine Windows API emulator or to ease cross-compilation and
  cross-debugging.

As QEMU requires no host kernel patches to run, it is very safe and easy
to use.

%package common
Summary: QEMU CPU Emulator - common files
Group: Emulators
Requires(pre): control >= 0.7.2
Requires(pre): shadow-utils sysvinit-utils
Requires: seavgabios seabios edk2-ovmf edk2-aarch64 qboot
Requires: ipxe-roms-qemu >= 1.0.0-alt4.git93acb5d
Requires: %name-img = %EVR
Conflicts: %rname-common
Conflicts: %rname-system-x86-core %rname-system-aarch64-core
Obsoletes: %name-aux < %EVR

%description common
QEMU is a fast processor emulator using dynamic translation to achieve
good emulation speed.
This package contains common files for qemu.

%package system
Summary: QEMU CPU Emulator - full system emulation
Group: Emulators
Requires: %name-common = %EVR pve-backup-client pve-backup-file-restore numactl
#Requires: passt
Conflicts: %rname-system %rname-ivshmem-tools %rname-tools %rname-kvm-core %rname-pr-helper %rname-img
Conflicts: %rname-system-x86-core %rname-system-aarch64-core

%description system
Full system emulation.  In this mode, QEMU emulates a full system
(for example a PC), including a processor and various peripherials.
It can be used to launch different Operating Systems without rebooting
the PC or to debug system code.

%package img
Summary: QEMU command line tool for manipulating disk images
Group: Emulators
Conflicts: %rname-img

%description img
This package provides a command line tool for manipulating disk images

%prep
%setup
mkdir debian
tar -xf %SOURCE99 -C debian --strip-components 1
mkdir -p subprojects/{keycodemapdb,berkeley-testfloat-3,berkeley-softfloat-3}
tar -xf %SOURCE100 -C subprojects/keycodemapdb --strip-components 1
tar -xf %SOURCE101 -C subprojects/berkeley-testfloat-3 --strip-components 1
tar -xf %SOURCE102 -C subprojects/berkeley-softfloat-3 --strip-components 1
cp -a subprojects/packagefiles/berkeley-testfloat-3/* subprojects/berkeley-testfloat-3/
cp -a subprojects/packagefiles/berkeley-softfloat-3/* subprojects/berkeley-softfloat-3/

for p in `cat debian/patches/series`; do
    patch -p1 < debian/patches/$p
done

cp %SOURCE13 block/vitastor.c
%patch -p1

%build
export CFLAGS="%optflags"
# non-GNU configure
./configure \
        --target-list=x86_64-softmmu,aarch64-softmmu \
        --prefix=%_prefix \
        --sysconfdir=%_sysconfdir \
        --libdir=%_libdir \
        --mandir=%_mandir \
        --libexecdir=%_libexecdir \
        --localstatedir=%_localstatedir \
        --extra-cflags="%optflags" \
        --with-pkgversion=%name-%version-%release \
        --firmwarepath="%firmwaredirs" \
        --disable-lto \
        --disable-werror \
        --disable-debug-tcg \
        --audio-drv-list="alsa" \
        --disable-capstone \
        --disable-gtk \
        --disable-guest-agent \
        --disable-guest-agent-msi \
        --disable-libnfs \
        --disable-libssh \
        --disable-sdl \
        --disable-smartcard \
        --disable-strip \
        --disable-xen \
        --enable-curl \
        --enable-gnutls \
        --enable-libiscsi \
        --enable-libusb \
        --enable-linux-aio \
        --enable-linux-io-uring \
        --enable-numa \
        --enable-rdma \
        --enable-opengl \
        --enable-rbd \
        --enable-vitastor \
        --enable-seccomp \
        --enable-slirp \
        --disable-passt \
        --enable-spice \
        --enable-usb-redir \
        --enable-virglrenderer \
        --enable-virtfs \
        --enable-zstd

%make_build V=1

%install
%makeinstall_std

%define docdir %_docdir/%name-%version
mkdir -p %buildroot%docdir
install -m644 LICENSE MAINTAINERS %buildroot%docdir/
rm -rf %buildroot%_docdir/qemu

install -m 0755 %SOURCE5 %buildroot%_bindir/qemu-kvm
ln -r -s %buildroot%_bindir/qemu-kvm %buildroot%_bindir/kvm
ln -r -s %buildroot%_bindir/qemu-kvm %buildroot%_bindir/qemu
ln -sf qemu.1.xz %buildroot%_man1dir/qemu-kvm.1.xz

rm -f %buildroot%_bindir/check-*
rm -f %buildroot%_desktopdir/%rname.desktop
rm -rf %buildroot%_iconsdir

# TODO:
# Install qemu-pr-helper service
#install -m 0644 contrib/systemd/qemu-pr-helper.service %%buildroot%%_unitdir/qemu-pr-helper.service
#install -m 0644 contrib/systemd/qemu-pr-helper.socket %%buildroot%%_unitdir/qemu-pr-helper.socket
# Install rules to use the bridge helper with libvirt's virbr0
install -D -m 0644 %SOURCE12 %buildroot%_sysconfdir/%name/bridge.conf

%if_enabled vnc_sasl
install -D -p -m 0644 qemu.sasl %buildroot%_sysconfdir/sasl2/%rname.conf
%endif

mkdir -p %buildroot%_sysconfdir/kvm
install -m 0755 debian/kvm-ifdown %buildroot%_sysconfdir/kvm/kvm-ifdown
install -m 0755 debian/kvm-ifup %buildroot%_sysconfdir/kvm/kvm-ifup

# CPU flags are static for QEMU version, allows avoiding more costly checks
mkdir -p %buildroot%_datadir/kvm
%buildroot%_bindir/qemu-system-x86_64 -cpu help | ./debian/parse-cpu-flags.pl > %buildroot%_datadir/kvm/recognized-CPUID-flags-x86_64
%buildroot%_bindir/qemu-system-x86_64 -machine help | ./debian/parse-machines.pl > %buildroot%_datadir/kvm/machine-versions-x86_64.json

%find_lang %rname

rm -f %buildroot%_datadir/%rname/pxe*rom
rm -f %buildroot%_datadir/%rname/efi*rom
rm -f %buildroot%_datadir/%rname/vgabios*bin
rm -f %buildroot%_datadir/%rname/bios.bin
rm -f %buildroot%_datadir/%rname/bios-256k.bin
rm -f %buildroot%_datadir/%rname/bios-microvm.bin
rm -f %buildroot%_datadir/%rname/qboot.rom
rm -f %buildroot%_datadir/%rname/openbios*
rm -f %buildroot%_datadir/%rname/*.dtb
rm -f %buildroot%_datadir/%rname/s390-*.img
rm -f %buildroot%_datadir/%rname/qemu_vga.ndrv
rm -f %buildroot%_datadir/%rname/slof.bin
rm -f %buildroot%_datadir/%rname/u-boot*
rm -f %buildroot%_datadir/%rname/palcode-clipper
rm -f %buildroot%_datadir/%rname/opensbi*
rm -f %buildroot%_datadir/%rname/edk2-*
rm -f %buildroot%_datadir/%rname/firmware/*
rm -f %buildroot%_datadir/%rname/qemu-nsis.bmp
rm -rf %buildroot%_includedir

for rom in e1000 ne2k_pci pcnet rtl8139 virtio eepro100 e1000e vmxnet3 ; do
  ln -r -s %buildroot%_datadir/ipxe/pxe-${rom}.rom %buildroot%_datadir/%rname/pxe-${rom}.rom
  ln -r -s %buildroot%_datadir/ipxe.efi/efi-${rom}.rom %buildroot%_datadir/%rname/efi-${rom}.rom
done

for bios in vgabios vgabios-cirrus vgabios-qxl vgabios-stdvga vgabios-vmware vgabios-virtio vgabios-ramfb vgabios-bochs-display vgabios-ati ; do
  ln -r -s %buildroot%_datadir/seavgabios/${bios}.bin %buildroot%_datadir/%rname/${bios}.bin
done

ln -r -s %buildroot%_datadir/seabios/{bios,bios-256k,bios-microvm}.bin %buildroot%_datadir/%rname/
ln -r -s %buildroot%_datadir/qboot/bios.bin %buildroot%_datadir/%rname/qboot.rom

mkdir -p %buildroot%_datadir/pve-edk2-firmware
ln -sf ../OVMF/OVMF_CODE.fd %buildroot%_datadir/pve-edk2-firmware/OVMF_CODE.fd
ln -sf ../OVMF/OVMF_VARS.fd %buildroot%_datadir/pve-edk2-firmware/OVMF_VARS.fd
ln -sf ../OVMF/OVMF_CODE_4M.fd %buildroot%_datadir/pve-edk2-firmware/OVMF_CODE_4M.fd
ln -sf ../OVMF/OVMF_VARS_4M.fd %buildroot%_datadir/pve-edk2-firmware/OVMF_VARS_4M.fd
ln -sf ../OVMF/OVMF_CODE_4M.secboot.fd %buildroot%_datadir/pve-edk2-firmware/OVMF_CODE_4M.secboot.fd
ln -sf ../OVMF/OVMF_VARS_4M.secboot.fd %buildroot%_datadir/pve-edk2-firmware/OVMF_VARS_4M.secboot.fd
ln -sf ../OVMF/OVMF_VARS_4M.ms.fd %buildroot%_datadir/pve-edk2-firmware/OVMF_VARS_4M.ms.fd
ln -sf ../AAVMF/AAVMF_CODE.fd %buildroot%_datadir/pve-edk2-firmware/AAVMF_CODE.fd
ln -sf ../AAVMF/AAVMF_VARS.fd %buildroot%_datadir/pve-edk2-firmware/AAVMF_VARS.fd


%check
# Disabled on aarch64 where it fails with several errors.  Will
# investigate and fix when we have access to real hardware
#ifnarch aarch64
#make V=1 check
#endif

%pre common
%_sbindir/groupadd -r -f %_group

%files

%files common
%dir %docdir/
%docdir/LICENSE
%docdir/MAINTAINERS
%_datadir/%rname
%_datadir/pve-edk2-firmware
%dir %_sysconfdir/%name
%if_enabled vnc_sasl
%config(noreplace) %_sysconfdir/sasl2/%rname.conf
%endif
%dir %_sysconfdir/kvm
%config(noreplace) %_sysconfdir/kvm/*
%_man7dir/qemu-block-drivers.*
%_man7dir/qemu-qmp-ref.*
%_man7dir/qemu-cpu-models.*
%_datadir/kvm

%files system -f %rname.lang
%_bindir/elf2dmp
%_bindir/qemu*system*
%_bindir/qemu-edid
%_bindir/qemu-storage-daemon
%_bindir/qemu-kvm
%_bindir/kvm
%_bindir/qemu
%_bindir/pbs-restore
%_bindir/vma
%_man1dir/qemu.1*
%_man1dir/qemu-kvm.1*
%attr(4710,root,vmusers) %_libexecdir/qemu-bridge-helper
%config(noreplace) %_sysconfdir/%name/bridge.conf
# TODO:
%_bindir/qemu-pr-helper

%if_enabled have_vmsr_helper
%_bindir/qemu-vmsr-helper
%endif

#%%_unitdir/qemu-pr-helper.service
#%%_unitdir/qemu-pr-helper.socket
%_libexecdir/vhost-user-gpu
%_man1dir/qemu-storage-daemon.1*
%_man7dir/qemu-storage-daemon-qmp-ref.*
%_man8dir/qemu-pr-helper.8*

%files img
%_bindir/qemu-img
%_bindir/qemu-io
%_bindir/qemu-nbd
%_man1dir/qemu-img.1*
%_man8dir/qemu-nbd.8*

%changelog
