# vim: set ft=spec: -*- rpm-spec -*-
%define        pkgname theforeman-puppetserver-foreman

Name:          puppet-%pkgname
Version:       2.2.0
Release:       alt2
Summary:       Puppet module for managing Foreman integration in Puppetserver
License:       GPLv3
Group:         Development/Ruby
Url:           https://github.com/theforeman/puppet-puppetserver_foreman
Vcs:           git@github.com:theforeman/puppet-puppetserver_foreman.git
Packager:      Ruby Maintainers Team <ruby@packages.altlinux.org>
BuildArch:     noarch

Source:        %name-%version.tar
Patch:         exceptions.patch
BuildRequires(pre): rpm-build-ruby

Requires:      puppet
Requires:      puppetserver
Obsoletes:     puppet-puppetserver-foreman < %EVR
Provides:      puppet-puppetserver-foreman = %EVR

%description
Puppet module for managing Foreman integration in Puppetserver.

The Foreman integration consists of an ENC and a report processor. This has a
configuration file. All of this can be managed by this module.

Historically this integration was part of theforeman-foreman module.


%prep
%setup
%autopatch -p1

%build
%ruby_build

%install
%ruby_install
chmod a+x %buildroot%_libexecdir/%name/files/*.rb
mkdir -p %buildroot%_libexecdir/puppet-modules/
mv %buildroot%_libexecdir/%name %buildroot%_libexecdir/puppet-modules/%pkgname

%check
%ruby_test

%files
%doc README*
%_libexecdir/puppet-modules/%pkgname


%changelog
