%define soname 7

Name: primecount
Version: 7.20
Release: alt1

Summary: Count the number of primes

License: BSD-2-Clause
Group: Sciences/Mathematics
Url: https://github.com/kimwalisch/primecount
VCS: https://github.com/kimwalisch/primecount

# Source-url: https://github.com/kimwalisch/primecount/archive/v%version.tar.gz#/%name-%version.tar.gz
Source: %name-%version.tar
Patch: %name-%version-%release.patch

BuildPreReq: rpm-build-ninja ctest
BuildRequires: gcc-c++ libgomp-devel cmake asciidoc-a2x libprimesieve-devel

%description
primecount is a command-line program that counts the primes below an
integer x less than or equal to 10^31 using highly optimized implementations of the
combinatorial prime counting algorithms.

%package -n lib%name%soname
Summary: C/C++ library for counting prime numbers
Group: System/Libraries

%description -n lib%name%soname
This package contains the shared runtime library for primecount.

%package -n lib%name-devel
Summary: Development files for the primecount library
Group: Development/Other

%description -n lib%name-devel
This package contains the C/C++ header files and the configuration
files for developing applications that use the primecount library.

%prep
%setup
%patch -p1

%build
%cmake \
    -GNinja \
%ifarch %e2k
    -DCMAKE_SHARED_LINKER_FLAGS="-fopenmp" \
    -DCMAKE_EXE_LINKER_FLAGS="-fopenmp" \
%endif
    -DBUILD_LIBPRIMESIEVE=OFF \
    -DBUILD_SHARED_LIBS=ON \
    -DBUILD_STATIC_LIBS=OFF \
    -DSTATICALLY_LINK_LIBPRIMECOUNT=OFF \
    -DBUILD_MANPAGE=ON \
%ifnarch i586
    -DBUILD_TESTS=ON \
%endif
    -DCMAKE_SKIP_RPATH:BOOL=OFF
cmake --build "%_cmake__builddir" -j%__nprocs

%install
%cmake_install

%ifnarch i586
%check
cd %_cmake__builddir
ctest
%endif

%files
%doc README.md ChangeLog
%_bindir/primecount
%_man1dir/primecount.1*

%files -n lib%name%soname
%doc COPYING
%_libdir/libprimecount.so.%soname
%_libdir/libprimecount.so.%version

%files -n lib%name-devel
%doc doc/libprimecount.md
%_libdir/libprimecount.so
%_includedir/primecount.h
%_includedir/primecount.hpp
%_pkgconfigdir/primecount.pc
%_libdir/cmake/primecount/

%changelog
