%define armips_commit a8d71f0f279eb0d30ecf6af51473b66ae0cf8e8d
%define discord_rpc_commit 963aa9f3e5ce81a4682c6ca3d136cddda614db33
%define glslang_commit 50e0708ec3a5c16020c4f845c654b80b8edb80bd
%define spirv_cross_commit 4212eef67ed0ca048cb726a6767185504e7695e5
%define cpu_features_commit fd4ffc1632db7b4e763bd28ffa6fc9d761cf3587
%define filesystem_commit 3f1c185ab414e764c694b8171d1c4d8c5c437517
%define ffmpeg_commit 82049cca2e4c1516ed00a77b502a21f91b7843f4
%define rcheevos_commit ef0e22bc076235315b94499bbd9f799a3c781708
%define libchdr_commit 26d27ca4903aaccd3ef41337b29bf5ecafb1f0ca
%define rapidjson_commit 73063f5002612c6bf64fe24f851cd5cc0d83eef9
%define lua_commit 7648485f14e8e5ee45e8e39b1eb4d3206dbd405a

%ifarch %ix86
%set_verify_elf_method textrel=relaxed
%endif

Name: ppsspp
Version: 1.19.3
Release: alt1

Summary: PlayStation Portable Emulator
License: GPL-2.0-or-later
Group: Emulators

Url: https://www.%name.org
Packager: Nazarov Denis <nenderus@altlinux.org>

ExcludeArch: ppc64le

# https://github.com/hrydgard/%name/releases/download/v%version/%name-%version.tar.xz
Source0: %name-%version.tar
# https://github.com/Kingcom/armips/archive/%armips_commit/armips-%armips_commit.tar.gz
Source1: armips-%armips_commit.tar
# https://github.com/discord/discord-rpc/archive/%discord_rpc_commit/discord-rpc-%discord_rpc_commit.tar.gz
Source2: discord-rpc-%discord_rpc_commit.tar
# https://github.com/hrydgard/glslang/archive/%glslang_commit/glslang-%glslang_commit.tar.gz
Source3: glslang-%glslang_commit.tar
# https://github.com/KhronosGroup/SPIRV-Cross/archive/%spirv_cross_commit/SPIRV-Cross-%spirv_cross_commit.tar.gz
Source4: SPIRV-Cross-%spirv_cross_commit.tar
# https://github.com/google/cpu_features/archive/%cpu_features_commit/cpu_features-%cpu_features_commit.tar.gz
Source5: cpu_features-%cpu_features_commit.tar
# https://github.com/Kingcom/filesystem/archive/%filesystem_commit/filesystem-%filesystem_commit.tar.gz
Source6: filesystem-%filesystem_commit.tar
# https://github.com/hrydgard/%name-ffmpeg/archive/%ffmpeg_commit/%name-ffmpeg-%ffmpeg_commit.tar.gz
Source7: %name-ffmpeg-%ffmpeg_commit.tar
# https://github.com/RetroAchievements/rcheevos/archive/%rcheevos_commit/rcheevos-%rcheevos_commit.tar.gz
Source8: rcheevos-%rcheevos_commit.tar
# https://github.com/rtissera/libchdr/archive/%libchdr_commit/libchdr-%libchdr_commit.tar.gz
Source9: libchdr-%libchdr_commit.tar
# https://github.com/Tencent/rapidjson/archive/%rapidjson_commit/rapidjson-%rapidjson_commit.tar.gz
Source10: rapidjson-%rapidjson_commit.tar
# https://github.com/hrydgard/ppsspp-lua/archive/%lua_commit/ppsspp-lua-%lua_commit.tar.gz
Source11: ppsspp-lua-%lua_commit.tar

Patch0: %name-alt-git.patch

Requires: %name-common = %EVR

BuildRequires(pre): fontconfig-devel
BuildRequires(pre): libpng-devel

BuildRequires: /proc
BuildRequires: cmake
BuildRequires: libGLEW-devel
BuildRequires: libSDL2_ttf-devel
BuildRequires: libminiupnpc-devel
BuildRequires: libsnappy-devel
BuildRequires: libwayland-cursor-devel
BuildRequires: libwayland-egl-devel
BuildRequires: libwayland-server-devel
BuildRequires: libzip-devel
BuildRequires: libzstd-devel
BuildRequires: openxr-devel
BuildRequires: qt5-multimedia-devel

%description
PPSSPP is a PSP emulator written in C++, and translates PSP CPU instructions directly into optimized x86, x64 and ARM machine code, using JIT recompilers (dynarecs).

%package common
Summary: PPSSPP assets
Group: Emulators
BuildArch: noarch

%description common
Required assets for PPSSPP GUI and assorted configuration files

%package headless
Summary: PlayStation Portable Emulator (headless)
Group: Emulators
Requires: %name-common = %EVR

%description headless
PPSSPP is a PSP emulator written in C++, and translates PSP CPU instructions directly into optimized x86, x64 and ARM machine code, using JIT recompilers (dynarecs).
This build headless only.

%package libretro
Summary: PlayStation Portable Emulator (libretro frontend)
Group: Emulators
Requires: retroarch

%description libretro
PPSSPP is a PSP emulator written in C++, and translates PSP CPU instructions directly into optimized x86, x64 and ARM machine code, using JIT recompilers (dynarecs).
This build using the libretro frontend.

%package qt
Summary: PlayStation Portable Emulator (Qt frontend)
Group: Emulators
Requires: %name-common = %EVR

%description qt
PPSSPP is a PSP emulator written in C++, and translates PSP CPU instructions directly into optimized x86, x64 and ARM machine code, using JIT recompilers (dynarecs).
This build using the Qt frontend.

%prep
%setup -b 1 -b 2 -b 3 -b 4 -b 5 -b 6 -b 7 -b 8 -b 9 -b 10 -b 11

%__mv -Tf ../armips-%armips_commit ext/armips
%__mv -Tf ../discord-rpc-%discord_rpc_commit ext/discord-rpc
%__mv -Tf ../glslang-%glslang_commit ext/glslang
%__mv -Tf ../SPIRV-Cross-%spirv_cross_commit ext/SPIRV-Cross
%__mv -Tf ../cpu_features-%cpu_features_commit ext/cpu_features
%__mv -Tf ../filesystem-%filesystem_commit ext/armips/ext/filesystem
%__mv -Tf ../%name-ffmpeg-%ffmpeg_commit ffmpeg
%__mv -Tf ../rcheevos-%rcheevos_commit ext/rcheevos
%__mv -Tf ../libchdr-%libchdr_commit ext/libchdr
%__mv -Tf ../rapidjson-%rapidjson_commit ext/rapidjson
%__mv -Tf ../%name-lua-%lua_commit ext/lua

%patch0 -p1

%build
%add_optflags -Wno-error=return-type

export CPLUS_INCLUDE_PATH=%_includedir/libzip

# Build SDL and headless versions

%define _cmake__builddir %_target_platform

%cmake \
	-DCMAKE_BUILD_TYPE:STRING=Release \
	-DUSE_SYSTEM_SNAPPY:BOOL=TRUE \
	-DUSE_SYSTEM_LIBZIP:BOOL=TRUE \
	-DUSE_SYSTEM_ZSTD:BOOL=TRUE \
	-DUSE_SYSTEM_MINIUPNPC:BOOL=TRUE \
	-DHEADLESS:BOOL=TRUE \
	-DLIBZIP_INCLUDE_DIR=%_includedir \
%ifarch %arm
	-DUSING_GLES2:BOOL=TRUE \
%else
	-DOpenGL_GL_PREFERENCE:STRING=GLVND \
%endif
	-Wno-dev

echo "// This is a generated file.

const char *PPSSPP_GIT_VERSION = \"%{version}\";

// If you don't want this file to update/recompile, change to 1.
#define PPSSPP_GIT_VERSION_NO_UPDATE 1
" > %_cmake__builddir/git-version.cpp

%cmake_build

# Build libretro versions

%define _cmake__builddir %_target_platform-libretro

%cmake \
	-DCMAKE_BUILD_TYPE:STRING=Release \
	-DUSE_SYSTEM_SNAPPY:BOOL=TRUE \
	-DUSE_SYSTEM_LIBZIP:BOOL=TRUE \
	-DUSE_SYSTEM_ZSTD:BOOL=TRUE \
	-DUSE_SYSTEM_MINIUPNPC:BOOL=TRUE \
	-DLIBRETRO:BOOL=TRUE \
	-DLIBZIP_INCLUDE_DIR=%_includedir \
%ifarch %arm
	-DUSING_GLES2:BOOL=TRUE \
%else
	-DOpenGL_GL_PREFERENCE:STRING=GLVND \
%endif
	-Wno-dev

echo "// This is a generated file.

const char *PPSSPP_GIT_VERSION = \"%{version}\";

// If you don't want this file to update/recompile, change to 1.
#define PPSSPP_GIT_VERSION_NO_UPDATE 1
" > %_cmake__builddir/git-version.cpp

%cmake_build

# Build Qt version

%define _cmake__builddir %_target_platform-qt

%cmake \
	-DCMAKE_BUILD_TYPE:STRING=Release \
	-DUSE_SYSTEM_SNAPPY:BOOL=TRUE \
	-DUSE_SYSTEM_LIBZIP:BOOL=TRUE \
	-DUSE_SYSTEM_ZSTD:BOOL=TRUE \
	-DUSE_SYSTEM_MINIUPNPC:BOOL=TRUE \
	-DUSING_QT_UI:BOOL=TRUE \
	-DLIBZIP_INCLUDE_DIR=%_includedir \
%ifarch %arm
	-DUSING_GLES2:BOOL=TRUE \
%else
	-DOpenGL_GL_PREFERENCE:STRING=GLVND \
%endif
	-Wno-dev

echo "// This is a generated file.

const char *PPSSPP_GIT_VERSION = \"%{version}\";

// If you don't want this file to update/recompile, change to 1.
#define PPSSPP_GIT_VERSION_NO_UPDATE 1
" > %_cmake__builddir/git-version.cpp

%cmake_build

%install
%define _cmake__builddir %_target_platform
%cmake_install
%__install -Dp -m0755 %_target_platform/PPSSPPHeadless %buildroot%_bindir/
%__mkdir_p %buildroot%_libexecdir/libretro
%__install -Dp -m0644 %_target_platform-libretro/lib/%{name}_libretro.so %buildroot%_libexecdir/libretro/

%define _cmake__builddir %_target_platform-qt
%cmake_install

%files
%_bindir/PPSSPPSDL
%_desktopdir/PPSSPPSDL.desktop

%files common
%doc LICENSE.TXT README.md
%_datadir/%name
%_datadir/mime/packages/%name.xml
%_iconsdir/hicolor/*/apps/%name.png
%_iconsdir/hicolor/scalable/apps/%name.svg

%files headless
%_bindir/PPSSPPHeadless

%files libretro
%_libexecdir/libretro/%{name}_libretro.so

%files qt
%_bindir/PPSSPPQt
%_desktopdir/PPSSPPQt.desktop

%changelog
