%define _unpackaged_files_terminate_build 1
%define u7s_admin_usr u7s-admin
%define u7s_admin_grp u7s-admin
%define kubernetes_grp kube
%define _libexecdir %_prefix/libexec
%define u7s_admin_homedir %_localstatedir/%u7s_admin_usr

Name: podsec
Version: 1.2.2
Release: alt1

Summary: Set of scripts for Podman Security
License: GPLv2+
Group: Development/Other
Url: https://github.com/alt-cloud/podsec
BuildArch: noarch

Source: %name-%version.tar

BuildRequires(pre): rpm-macros-systemd
BuildRequires(pre): libsystemd-devel
BuildRequires(pre): ronn

Requires: nginx
Requires: docker-registry
Requires: pinentry-common

%description
This package contains utilities for:
- setting the most secure container application access policies
  (directory /etc/containers/)
- installation of a registry and a web server for access to image signatures
- creating a user with rights to create docker images, signing them and
  placing them in the registry
- creating users with rights to run containers in rootless mode
- downloading docker images from the oci archive, placing them
  on the local system, signing and placing them on the registry
- deploying a rootless kubernetes cluster

%package k8s
Summary: Set of scripts for Kubernetes Security
Group: Development/Other
Requires: cri-tools

%description k8s
This package contains utilities for:
- deploying a rootless kubernetes cluster
- cluster node configurations

%package k8s-rbac
Summary: Set of scripts for Kubernetes RBAC
Group: Development/Other

%description k8s-rbac
This package contains utilities for
- creating RBAC users
- generation of certificates and configuration files for users
- generating cluster and usual roles and binding them to users

%package inotify
Summary: Set of scripts for security monitoring
Group: Development/Other
Requires: trivy
Requires: trivy-server

%description inotify
A set of scripts for  security monitoring by systemd timers
to monitor and identify security threats

%package dev
Summary: Set of scripts for podsec developers
Group: Development/Other

%description dev
A set of scripts for developers

%package icinga
Summary: %name-inotify monitoring templates for Icinga 2
Group: Monitoring
Requires: nagwad-icinga-templates >= 0.11.2

%description icinga
Monitoring templates for Icinga 2 defining services to monitor
various Podsec events.

%package nagios
Summary: %name-inotify monitoring templates for Nagios
Group: Monitoring
Requires: nagwad-nagios-templates >= 0.11.2

%description nagios
Monitoring templates for Nagios defining services to monitor
various Podsec events.

%prep
%setup

%build
%make_build

%install
%makeinstall_std unitdir=%_unitdir modulesloaddir=%_modules_loaddir

# JSON templates are packaged using %%doc:
rm -fv %buildroot%_datadir/doc/podsec/podsec-icinga2.json

%pre
groupadd -r -f podman >/dev/null 2>&1 ||:
groupadd -r -f podman_dev >/dev/null 2>&1 ||:

%pre k8s
groupadd -r -f %u7s_admin_grp  2>&1 ||:
useradd -M -r -g %u7s_admin_grp -d %u7s_admin_homedir -G %kubernetes_grp,systemd-journal,podman \
    -c 'usernet user account'  %u7s_admin_usr  2>&1 ||:
mkdir -p %u7s_admin_homedir
# merge usernetes & podman graphroot
mkdir -p %u7s_admin_homedir/.local/share/usernetes/containers 2>&1 ||:
cd %u7s_admin_homedir/.local/share
if [ -d containers ]; then mv containers containers.old; rm -rfv containers.old; fi
ln -sf usernetes/containers . 2>&1 ||:
cd %u7s_admin_homedir/.local/share/usernetes/containers
chown -R %u7s_admin_usr:%u7s_admin_grp %u7s_admin_homedir

%post inotify
%post_systemd podsec-inotify-check-containers.service
%post_systemd podsec-inotify-check-kubeapi.service

%preun inotify
%preun_systemd podsec-inotify-check-containers.service
%preun_systemd podsec-inotify-check-kubeapi.service

%post k8s
%post_systemd  u7s.service

%preun k8s
%preun_systemd u7s.service

%files
%dir %_mandir/ru/man1
%dir %_sysconfdir/nagwad/
%_datadir/locale/ru/LC_MESSAGES/podsec.mo
%_mandir/ru/man1/podsec-create-imagemakeruser.1.xz
%_mandir/ru/man1/podsec-create-podmanusers.1.xz
%_mandir/ru/man1/podsec-create-policy.1.xz
%_mandir/ru/man1/podsec-create-services.1.xz
%_mandir/ru/man1/podsec-load-sign-oci.1.xz
%_mandir/man1/podsec-create-imagemakeruser.1.xz
%_mandir/man1/podsec-create-podmanusers.1.xz
%_mandir/man1/podsec-create-policy.1.xz
%_mandir/man1/podsec-create-services.1.xz
%_mandir/man1/podsec-load-sign-oci.1.xz
%config(noreplace) %_sysconfdir/nagwad/podsec.sed
%dir %_sysconfdir/podsec
%dir %_libexecdir/podsec
%dir %_localstatedir/podsec
%_bindir/podsec-functions
%_bindir/podsec-get-platform
%_bindir/podsec-load-sign-oci
%_bindir/podsec-policy-functions
%defattr (0700,root,root, -)
%_bindir/podsec-create-imagemakeruser
%_bindir/podsec-create-podmanusers
%_bindir/podsec-create-policy
%_bindir/podsec-create-services


%files k8s
%_datadir/locale/ru/LC_MESSAGES/podsec-k8s.mo
%_bindir/podsec-u7s-kubeadm
%_bindir/podsec-u7s-functions
%_unitdir/u7s.service
%_unitdir/user@.service.d/delegate.conf

%config %_modules_loaddir/u7s.conf
%dir %_mandir/ru/man1
%_mandir/ru/man1/podsec-u7s-kubeadm.1.xz
%_mandir/man1/podsec-u7s-kubeadm.1.xz
%_userunitdir/kubelet.service
%_userunitdir/rootlesskit.service

%defattr (0700,%u7s_admin_usr,%u7s_admin_grp, 0700)
%dir %_sysconfdir/podsec/u7s
%dir %_sysconfdir/podsec/u7s/audit
%dir %_sysconfdir/podsec/u7s/config
%dir %_sysconfdir/podsec/u7s/config/cni_net.d
%dir %_sysconfdir/podsec/u7s/config/flannel
%dir %_sysconfdir/podsec/u7s/config/flannel/cni_net.d
%dir %_sysconfdir/podsec/u7s/config/flannel/etcd
%dir %_sysconfdir/podsec/u7s/config/kubeadm-configs
%dir %_sysconfdir/podsec/u7s/env
%dir %_sysconfdir/podsec/u7s/manifests/
%dir %_sysconfdir/podsec/u7s/manifests/kube-flannel
%dir %_sysconfdir/podsec/u7s/manifests/kube-flannel/*
%dir %_sysconfdir/podsec/u7s/manifests/kube-flannel/*/*
%dir %_sysconfdir/podsec/u7s/manifests/kube-flannel/*/*/*

%dir %u7s_admin_homedir
%dir %u7s_admin_homedir/.local
%dir %u7s_admin_homedir/.local/share
%dir %u7s_admin_homedir/.local/share/usernetes
%dir %u7s_admin_homedir/.local/share/usernetes/containers

%dir %_localstatedir/podsec/u7s
%dir %_localstatedir/podsec/u7s/etcd
%dir %_localstatedir/podsec/u7s/log
%dir %_localstatedir/podsec/u7s/log/kubeapi
%dir %_libexecdir/podsec/u7s
%dir %_libexecdir/podsec/u7s/bin

%_libexecdir/podsec/u7s/bin/kubeadm
%_libexecdir/podsec/u7s/bin/u7sinit.sh
%_libexecdir/podsec/u7s/bin/crio.sh
%_libexecdir/podsec/u7s/bin/init-crio.sh
%_libexecdir/podsec/u7s/bin/_kubeadm.sh
%_libexecdir/podsec/u7s/bin/_kubelet.sh
%_libexecdir/podsec/u7s/bin/rootlessctl
%_libexecdir/podsec/u7s/bin/systemctl
%_libexecdir/podsec/u7s/bin/u7s-start-stop.sh
%_libexecdir/podsec/u7s/bin/kubeadm.sh
%_libexecdir/podsec/u7s/bin/kubelet.sh
%_libexecdir/podsec/u7s/bin/nsenter_u7s
%_libexecdir/podsec/u7s/bin/rootlesskit.sh

%defattr (0600,%u7s_admin_usr,%u7s_admin_grp, -)
%config %_sysconfdir/podsec/u7s/config/kubeadm-configs/InitClusterConfiguration.yaml
%config %_sysconfdir/podsec/u7s/config/kubeadm-configs/InitConfiguration.yaml
%config %_sysconfdir/podsec/u7s/config/kubeadm-configs/JoinClusterConfiguration.yaml
%config %_sysconfdir/podsec/u7s/config/kubeadm-configs/JoinConfiguration.yaml
%config %_sysconfdir/podsec/u7s/config/kubeadm-configs/JoinControlPlaneConfijuration.yaml
%config %_sysconfdir/podsec/u7s/config/kubeadm-configs/KubeletConfiguration.yaml
%config %_sysconfdir/podsec/u7s/config/kubeadm-configs/KubeProxyConfiguration.yaml
%config %_sysconfdir/podsec/u7s/env/u7s_flags
%config %_sysconfdir/podsec/u7s/env/u7s_images
%config %_sysconfdir/podsec/u7s/manifests/coredns.yaml
%config %_sysconfdir/podsec/u7s/manifests/kube-flannel/*/*/*/kube-flannel.yml
%config %_sysconfdir/podsec/u7s/config/cni_net.d/99-loopback.conf
%config %_sysconfdir/podsec/u7s/audit/policy.yaml
%config %_sysconfdir/podsec/u7s/config/flannel/etcd/coreos.com_network_config
%config %_sysconfdir/podsec/u7s/config/env
%config %_sysconfdir/podsec/u7s/config/ENV
%config %_sysconfdir/podsec/u7s/config/flannel/cni_net.d/10-flannel.conflist

%files k8s-rbac
%_datadir/locale/ru/LC_MESSAGES/podsec-k8s-rbac.mo
%_bindir/podsec-k8s-rbac-bindrole
%_bindir/podsec-k8s-rbac-create-kubeconfig
%_bindir/podsec-k8s-rbac-create-remoteplace
%_bindir/podsec-k8s-rbac-create-user
%_bindir/podsec-k8s-rbac-functions
%_bindir/podsec-k8s-rbac-get-userroles
%_bindir/podsec-k8s-rbac-unbindrole
%dir %_mandir/ru/man1
%_mandir/ru/man1/podsec-k8s-rbac-bindrole.1.xz
%_mandir/ru/man1/podsec-k8s-rbac-create-kubeconfig.1.xz
%_mandir/ru/man1/podsec-k8s-rbac-create-remoteplace.1.xz
%_mandir/ru/man1/podsec-k8s-rbac-create-user.1.xz
%_mandir/ru/man1/podsec-k8s-rbac-get-userroles.1.xz
%_mandir/ru/man1/podsec-k8s-rbac-unbindrole.1.xz
%_mandir/man1/podsec-k8s-rbac-bindrole.1.xz
%_mandir/man1/podsec-k8s-rbac-create-kubeconfig.1.xz
%_mandir/man1/podsec-k8s-rbac-create-remoteplace.1.xz
%_mandir/man1/podsec-k8s-rbac-create-user.1.xz
%_mandir/man1/podsec-k8s-rbac-get-userroles.1.xz
%_mandir/man1/podsec-k8s-rbac-unbindrole.1.xz

%files inotify
%dir %_mandir/ru/man1
%_mandir/ru/man1/podsec-inotify-build-invulnerable-image.1.xz
%_mandir/ru/man1/podsec-inotify-check-containers.1.xz
%_mandir/ru/man1/podsec-inotify-check-images.1.xz
%_mandir/ru/man1/podsec-inotify-check-kubeapi.1.xz
%_mandir/ru/man1/podsec-inotify-check-policy.1.xz
%_mandir/ru/man1/podsec-inotify-check-vuln.1.xz
%_mandir/man1/podsec-inotify-build-invulnerable-image.1.xz
%_mandir/man1/podsec-inotify-check-containers.1.xz
%_mandir/man1/podsec-inotify-check-images.1.xz
%_mandir/man1/podsec-inotify-check-kubeapi.1.xz
%_mandir/man1/podsec-inotify-check-policy.1.xz
%_mandir/man1/podsec-inotify-check-vuln.1.xz
%_unitdir/podsec-inotify-check-containers.service
%_unitdir/podsec-inotify-check-images.service
%_unitdir/podsec-inotify-check-images.timer
%_unitdir/podsec-inotify-check-kubeapi-mail.service
%_unitdir/podsec-inotify-check-kubeapi-mail.timer
%_unitdir/podsec-inotify-check-kubeapi.service
%_unitdir/podsec-inotify-check-policy.service
%_unitdir/podsec-inotify-check-policy.timer
%_unitdir/podsec-inotify-check-vuln.service
%_unitdir/podsec-inotify-check-vuln.timer

%_bindir/podsec-inotify-functions
%_datadir/locale/ru/LC_MESSAGES/podsec-inotify.mo
%_bindir/podsec-inotify-build-invulnerable-image
%_bindir/podsec-inotify-check-vuln

%defattr (0500,root, root, -)
%_bindir/podsec-inotify-check-containers
%_bindir/podsec-inotify-check-images
%_bindir/podsec-inotify-check-kubeapi
%_bindir/podsec-inotify-check-policy

%files dev
%dir %_mandir/ru/man1
%_mandir/man1/podsec-k8s-save-oci.1.xz
%_mandir/ru/man1/podsec-k8s-save-oci.1.xz
%_mandir/man1/podsec-save-oci.1.xz
%_mandir/ru/man1/podsec-save-oci.1.xz
%defattr (0400,%u7s_admin_usr,%u7s_admin_grp, -)
%_bindir/podsec-save-oci
%_bindir/podsec-k8s-save-oci

%files icinga
%doc podsec-inotify/monitoring/podsec-icinga2.json
%config(noreplace) %_sysconfdir/icinga2/conf.d/podsec.conf

%files nagios
%config(noreplace) %_sysconfdir/nagios/templates/podsec-services.cfg
%config(noreplace) %_sysconfdir/nagios/nrpe-commands/podsec-commands.cfg

%changelog
