Group: Graphics
BuildRequires: libgomp-devel /proc
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
%global libname libimagequant

Name:           pngquant
Version:        2.18.0
Release:        alt1_9
Summary:        PNG quantization tool for reducing image file size

License:        GPL-3.0-or-later

%global _smp_build_ncpus 1

URL:            http://%{name}.org
Source0:        https://github.com/pornel/%{name}/archive/%{version}/%{name}-%{version}.tar.gz
# Comment out failing test on EL < 8 due to old libpng
Patch1:         pngquant-old_libpng.patch

BuildRequires:  gcc
BuildRequires:  sed
BuildRequires:  libpng-devel libpng17-tools
BuildRequires:  zlib-devel >= 1.2.3
BuildRequires:  liblcms2-devel
BuildRequires:  %{libname}-devel

Requires:       libpng16 >= 1.2.46
Requires:       zlib >= 1.2.3
Requires:       %{libname}
Source44: import.info


%description
%{name} converts 24/32-bit RGBA PNG images to 8-bit palette with alpha channel
preserved.  Such images are compatible with all modern web browsers and a
compatibility setting is available to help transparency degrade well in
Internet Explorer 6.  Quantized files are often 40-70 percent smaller than
their 24/32-bit version. %{name} uses the median cut algorithm.


%prep
%setup -q
%if 0%{?rhel} &&  0%{?rhel} < 8
%patch1  -p1 -b .oldlibpng
%endif

# Relax version check for compatibility with newer libimagequant
sed -i 's/fgrep 2./grep -E "2|4."/' test/test.sh

%build
# add some speed-relevant compiler-flags
export CFLAGS="%{optflags} -fno-math-errno -funroll-loops -fomit-frame-pointer -fPIC"
%configure --with-openmp --with-libimagequant
%make_build


%install
%makeinstall_std


%check
# Neuter test failures on s390x due to
#  test: test/test.c:81: test_histogram: Assertion `LIQ_OK == err' failed.
%ifarch s390x
%make_build test || true
%else
%make_build test
%endif


%files
%doc README.md CHANGELOG
%doc --no-dereference COPYRIGHT
%{_bindir}/%{name}
%{_mandir}/man1/%{name}.1*


%changelog
