%define _unpackaged_files_terminate_build 1

Name: plexus-classworlds
Version: 2.9.0
Release: alt1

Summary: Plexus Classworlds Classloader Framework
License: Apache-2.0
Group: Development/Java
Url: https://github.com/codehaus-plexus/plexus-classworlds
Vcs: https://github.com/codehaus-plexus/plexus-classworlds.git
BuildArch: noarch

Source0: %name-%version.tar

BuildRequires: maven-local
BuildRequires: rpm-build-java-osgi
BuildRequires: /proc
BuildRequires: jpackage-default
BuildRequires: mvn(junit:junit)
BuildRequires: mvn(org.apache.felix:maven-bundle-plugin)
BuildRequires: mvn(org.codehaus.plexus:plexus:pom:)

%description
Classworlds is a framework for container developers
who require complex manipulation of Java's ClassLoaders.
Java's native ClassLoader mechanisms and classes can cause
much headache and confusion for certain types of
application developers. Projects which involve dynamic
loading of components or otherwise represent a 'container'
can benefit from the classloading control provided by
classworlds.

%{?javadoc_package}

%prep
%setup

%mvn_file : %name plexus/plexus-classworlds plexus/classworlds
%mvn_alias : classworlds:classworlds

%pom_add_dep junit:junit:4.13.1:test

%pom_remove_plugin :maven-dependency-plugin

%build
%mvn_build -- -Dmaven.compiler.source=1.8 \
  -Dmaven.compiler.target=1.8 \
  -Dmaven.javadoc.source=1.8 \
  -Dmaven.compiler.release=8 \
  -Dtest=!ConfiguratorTest \
  #

%install
%mvn_install

%files -f .mfiles
%doc --no-dereference LICENSE.txt LICENSE-Codehaus.txt

%changelog
