%define _libexecdir %_prefix/libexec

Name: platon
Version: 20250917
Release: alt1

Summary: PLATON is a versatile SHELX compatible multipurpose crystallographic tool
License: ALT-Proprietary-PLATON
Group: Sciences/Chemistry

Url: http://www.platonsoft.nl/platon/
Source: http://www.platonsoft.nl/spek/xraysoft/unix/%name.tar.gz
Source1: %name.sh
Source2: http://www.platonsoft.nl/spek/xraysoft/update_history_platon.html
Source3: http://www.platonsoft.nl/spek/xraysoft/old_update_history_platon.html
Source4: PERMISSION.txt

# Automatically added by buildreq on Fri Nov 28 2008
BuildRequires: gcc-fortran libX11-devel

Requires: %name-doc = %version-%release

%description
PLATON is a versatile SHELX compatible multipurpose
crystallographic tool.

Most PLATON features complement those available in the excellent
and widely distributed SHELX package for crystal structure
determination and refinement.

Historically (1980) PLATON started out as a program for the
automated calculation of derived geometrical data (i.e. bond
distances, bond angles and torsion angles, including su's
(esd's)) for structures refined with SHELX76.  Since then,
that basic function evolved into an automatic function to
calculate everything of possible interest (both intra- and
intermolecular)for a given structural parameter set
(Instruction: CALC).

Over time, various other tools were introduced (Molecular
Graphics i.e. PLUTON & ORTEP, Absorption correction, Data
Validation etc.), some of which requiring a reflection datafile
as well.

Several functions in PLATON (e.g. SPGR and EXOR) are there to
implement calculations needed for datareduction, structure
determination and refinement with a program system called
'SYSTEM-S'.

------------------------------------------------------------
PLATON is free of charge for Academics.

Please note that commecrial users should apply for a license:
http://www.cryst.chem.uu.nl/platon/pl030000.html

See also %_defaultdocdir/%name-common-%version/PERMISSION.txt

%package common
Summary: Common package for %name
Group: Sciences/Chemistry
BuildArch: noarch

%description common
PLATON is a versatile SHELX97 compatible multipurpose
crystallographic tool. This is common package for PLATON.


%package doc
Summary: English manual for PLATON
Group: Sciences/Chemistry
BuildArch: noarch
Requires: %name-bin = %version-%release

%description doc
PLATON is a versatile SHELX97 compatible multipurpose
crystallographic tool. This package contains the English
version of the PLATON user's manual.

%package bin
Summary: PLATON is a versatile SHELX97 compatible multipurpose crystallographic tool
Group: Sciences/Chemistry
Requires: %name-common = %version-%release

%description bin
PLATON is a versatile SHELX97 compatible multipurpose
crystallographic tool. This package contains the
executable binary file.

%prep
%setup -n %name
gunzip platon.f.gz
gunzip xdrvr.c.gz
tar -vvxf platon_html.tar.gz
mv platon doc
rm -f doc/index.html
chmod -c -Rf u+rwX,go-w doc
mv TEST test
cp -a %SOURCE1 .
cp -a %SOURCE2 .
cp -a %SOURCE3 .
cp -a %SOURCE4 .

%build
g77 %optflags -o platon platon.f xdrvr.c -lX11

%install
install -d %buildroot%_bindir
install -pm755 %name.sh %buildroot%_bindir/%name

# add pseudonyms
ln -s %name %buildroot%_bindir/pluton
ln -s %name %buildroot%_bindir/s
ln -s %name %buildroot%_bindir/cifchk
ln -s %name %buildroot%_bindir/helena
ln -s %name %buildroot%_bindir/stidy

install -d %buildroot%_libexecdir/%name
install -pm755 %name %buildroot%_libexecdir/%name

install -d %buildroot%_datadir/%name
install -pm644 check.def %buildroot%_datadir/%name

install -d %buildroot%_datadir/%name/{ABSORB_EXAMPLE,ABSTOMPA_EXAMPLE,ABSTOMPA_TEST,ADDSYM_EXAMPLE,ASYM_EXAMPLE,MULABS_EXAMPLE,PSICOR_EXAMPLE,SQUEEZE_EXAMPLE}
install -pm644 test/ABSORB_EXAMPLE/* %buildroot%_datadir/%name/ABSORB_EXAMPLE/
install -pm644 test/ABSTOMPA_EXAMPLE/* %buildroot%_datadir/%name/ABSTOMPA_EXAMPLE/
install -pm644 test/ABSTOMPA_TEST/* %buildroot%_datadir/%name/ABSTOMPA_TEST/
install -pm644 test/ADDSYM_EXAMPLE/* %buildroot%_datadir/%name/ADDSYM_EXAMPLE/
install -pm644 test/ASYM_EXAMPLE/* %buildroot%_datadir/%name/ASYM_EXAMPLE/
install -pm644 test/MULABS_EXAMPLE/* %buildroot%_datadir/%name/MULABS_EXAMPLE/
install -pm644 test/PSICOR_EXAMPLE/* %buildroot%_datadir/%name/PSICOR_EXAMPLE/
install -pm644 test/SQUEEZE_EXAMPLE/* %buildroot%_datadir/%name/SQUEEZE_EXAMPLE/

install -d %buildroot%_defaultdocdir/%name/{images,PLATON-MANUAL.data,pl000314_files}
#install -pm644 doc/{*.html,*.pdf,*.lis,*.spf,*.ps,*.res,*.mis,*.hkl,*.ins,*.dat,*.Z,*.fcf,*.acc,*.sup,*.lps,*.pdb,*.eps,*.jnl,*.cif} \
#        %buildroot%_defaultdocdir/%name
install -pm644 doc/{*.html,*.pdf,*.lis,*.spf,*.ps,*.res,*.mis,*.hkl,*.ins,*.Z,*.fcf,*.acc,*.sup,*.lps,*.pdb,*.eps,*.jnl,*.cif} \
        %buildroot%_defaultdocdir/%name
ln -s pl000000.html %buildroot%_defaultdocdir/%name/index.html
install -pm644 doc/images/* %buildroot%_defaultdocdir/%name/images
install -pm644 doc/PLATON-MANUAL.data/* %buildroot%_defaultdocdir/%name/PLATON-MANUAL.data
install -pm644 doc/pl000314_files/* %buildroot%_defaultdocdir/%name/pl000314_files

%files
# nothing to pack

%files common
%doc README README.ADDSYM README.LEPAGE update_history_platon.html old_update_history_platon.html PERMISSION.txt
%_bindir/*
%_datadir/%name

%files bin
%_libexecdir/%name

%files doc
%_defaultdocdir/%name

%changelog
