%add_findreq_skiplist %perl_vendor_archlib/*

%def_disable perl
%def_disable tcl
%def_disable tk
%def_enable nss
%def_enable cyrus_sasl
%def_disable gnutls
%def_disable gevolution
%def_enable meanwhile
%def_disable cap
%def_enable nm
%def_disable mono
%def_enable consoleui
%def_enable dbus
%def_enable avahi
%def_enable dot
%def_enable doxygen
%def_enable relnot
%def_enable idn
%def_enable farstream
%def_enable gstreamer
%def_enable screensaver
%def_enable gestures
%def_enable gtkspell
%def_enable devhelp

# X session management
%def_enable sm

# voice and video
%def_enable vv

Name: pidgin
Version: 2.14.14
Release: alt1

Summary: A GTK+ based multiprotocol instant messaging client
License: GPLv2
Group: Networking/Instant messaging
Url: http://pidgin.im

Provides: gaim = %version
Obsoletes: gaim
%{?_disable_gevolution:Obsoletes: pidgin-gevolution <= %version-%release}

Conflicts: pidgin-mini

Requires: libpurple = %version-%release
Requires(pre): GConf

Source0: %name-%version.tar
Source2: purple-altlinux-prefs.xml
Patch0: %name-%version-%release.patch

# From configure.ac
BuildRequires: glib2-devel libgtk+2-devel libgio-devel >= 2.26
BuildRequires: libpango-devel >= 1.4.0
BuildRequires: libXext-devel libX11-devel
%{?_enable_gtkspell:BuildRequires: libgtkspell-devel >= 2.0.2}
%{?_enable_nss:BuildRequires: libnss-devel libnspr-devel}
%{?_enable_cyrus_sasl:BuildRequires: libsasl2-devel}
%{?_enable_gnutls:BuildRequires: libgnutls-devel}
%{?_enable_consoleui:BuildRequires: libncurses-devel libncursesw-devel libgnt-devel >= 2.14.0}
%{?_enable_nm:BuildRequires: libnm-devel}
%{?_enable_meanwhile:BuildRequires: libmeanwhile-devel}
%{?_enable_perl:BuildRequires: perl-devel}
%{?_enable_tcl:BuildRequires: tcl-devel}
%{?_enable_tk:BuildRequires: tk-devel}
%{?_enable_mono:BuildRequires: mono-devel mono-mcs rpm-build-mono mono-nunit-devel /proc}
%{?_enable_gevolution:BuildRequires: evolution-data-server-devel}
%{?_enable_dbus:BuildRequires: libdbus-devel >= 0.35 libdbus-glib-devel >= 0.35}
%{?_enable_avahi:BuildRequires: libavahi-devel libavahi-glib-devel}
%{?_enable_dot:BuildRequires: graphviz}
%{?_enable_doxygen:BuildRequires: doxygen}
%{?_enable_idn:BuildRequires: libidn-devel}
%{?_enable_farstream:BuildRequires: libfarstream0.2-devel >= 0.2.7}
%{?_enable_vv:BuildRequires: gst-plugins1.0-devel}
%{?_enable_gstreamer:BuildRequires: gstreamer1.0-devel}
%{?_enable_sm:BuildRequires: libSM-devel}
%{?_enable_screensaver:BuildRequires: libXScrnSaver-devel xorg-scrnsaverproto-devel}
BuildRequires: libsqlite3-devel >= 3.3
BuildRequires: libxml2-devel >= 2.6.0
BuildRequires(pre): GConf libGConf-devel

BuildRequires: gcc-c++ libgpg-error
BuildRequires: python3-devel
# for shared gadu plugin
BuildRequires: libgadu-devel >= 1.11.0
BuildRequires: intltool
# now intltool wants that
BuildRequires: perl-XML-Parser

BuildRequires: desktop-file-utils
BuildRequires: ca-certificates

%description
Pidgin allows you to talk to anyone using a variety of messaging
protocols including XMPP, Bonjour, Gadu-Gadu,
IRC, Novell Groupwise, QQ, Lotus Sametime, SILC, Simple and
Zephyr.  These protocols are implemented using a modular, easy to
use design.  To use a protocol, just add an account using the
account editor.

Pidgin supports many common features of other clients, as well as many
unique features, such as perl scripting, TCL scripting and C plugins.

%package devel
Summary: Development headers, documentation, and libraries for Pidgin
Group: Development/Other
Requires: %name = %version-%release
Requires: libpurple-devel = %version-%release
Provides: gaim-devel = %version
Obsoletes: gaim-devel
Conflicts: pidgin-mini-devel

%description devel
The pidgin-devel package contains the header files, developer
documentation, and libraries required for development of Pidgin scripts
and plugins.

%package -n libpurple
Summary: libpurple library for IM clients like Pidgin and Finch
Group: System/Libraries
Requires: ca-certificates
Conflicts: libpurple-mini

%description -n libpurple
libpurple contains the core IM support for IM clients such as Pidgin
and Finch.

libpurple supports a variety of messaging protocols including
XMPP, Bonjour, Gadu-Gadu, IRC, Novell Groupwise, QQ,
Lotus Sametime, SILC, Simple and Zephyr.

%package -n libpurple-devel
Summary: Development headers, documentation, and libraries for libpurple
Group: Development/Other
Requires: libpurple = %version-%release
Conflicts: libpurple-mini-devel

%description -n libpurple-devel
The libpurple-devel package contains the header files, developer
documentation, and libraries required for development of libpurple based
instant messaging clients or plugins for any libpurple based client.

%if_enabled relnot
%package -n %name-relnot
Summary: Release notification plugin for Pidgin
Group: Networking/Instant messaging
Requires: %name = %version-%release

%description -n %name-relnot
Release notification plugin for Pidgin.
%endif

%if_enabled gevolution
%package -n %name-gevolution
Summary: Gevolution plugin for Pidgin
Group: Networking/Instant messaging
Requires: %name = %version-%release
Obsoletes: gaim-gevolution
Provides: gaim-gevolution = %version

%description -n %name-gevolution
Gevolution plugin for Pidgin.
%endif

%if_enabled mono
%package -n libpurple-mono
Summary: Mono .NET plugin support for Pidgin
Group: Networking/Instant messaging
Requires: libpurple = %version-%release
Obsoletes: gaim-mono
Provides: gaim-mono = %version

%description -n libpurple-mono
Mono support for Pidgin.
%endif

%if_enabled perl
%package -n libpurple-perl
Summary: Perl support for Pidgin
Group: Networking/Instant messaging
Requires: libpurple = %version-%release
Requires: perl-base
Obsoletes: gaim-perl
Provides: gaim-perl = %version

%description -n libpurple-perl
Perl support for Pidgin.
%endif

%if_enabled tcl
%package -n libpurple-tcl
Summary: Tcl/Tk support for Pidgin
Group: Networking/Instant messaging
Requires: libpurple = %version-%release
Obsoletes: gaim-tcl
Provides: gaim-tcl = %version

%description -n libpurple-tcl
Tcl/Tk support for Pidgin.
%endif

%if_enabled consoleui
%package -n finch
Summary: A text-based user interface for Pidgin
Group: Networking/Instant messaging
Requires: libpurple = %version-%release
Provides: gaim-text = %version
Obsoletes: gaim-text

%description -n finch
A text-based user interface for using libpurple.  This can be run from a
standard text console or from a terminal within X Windows.  It
uses ncurses and our homegrown gnt library for drawing windows
and text.

%package -n finch-devel
Summary: Headers etc. for finch stuffs
Group: Development/Other
Requires: finch = %version-%release
Requires: libpurple-devel = %version-%release
Provides: gaim-text-devel = %version
Obsoletes: gaim-text-devel

%description -n finch-devel
The finch-devel package contains the header files, developer
documentation, and libraries required for development of Finch scripts
and plugins.
%endif

%if_enabled dbus
%package -n libpurple-dbus
Summary: D-Bus client utilities for Pidgin
Group: Networking/Instant messaging
Requires: %name = %version-%release
Requires: libpurple-client = %version-%release
Obsoletes: gaim-dbus
Provides: gaim-dbus = %version

%description -n libpurple-dbus
D-Bus client utilities for Pidgin.

%package -n libpurple-client
Summary: Client library for IM clients like Pidgin and Finch
Group: System/Libraries

%description -n libpurple-client
This package provides client library for purple-based IM like Pidgin and Finch
%endif

%prep
%setup
%patch0 -p1

cp %SOURCE2 prefs.xml

# Bug #528796: Get rid of #!/usr/bin/env python
# Upstream refuses to use ./configure --python-path= in these scripts.
for file in finch/plugins/pietray.py libpurple/plugins/dbus-buddyicons-example.py \
            libpurple/plugins/startup.py libpurple/purple-notifications-example; do
    sed -i 's/env python/python3/' $file
done

%build
%add_optflags -Wno-error=incompatible-pointer-types
%autoreconf
%configure \
	--disable-schemas-install \
	%{subst_enable avahi} \
	%{subst_enable dot} \
	%{subst_enable doxygen} \
	%{subst_enable mono} \
	%{subst_enable cap} \
	%{subst_enable nm} \
	%{subst_enable perl} \
	%{subst_enable gevolution} \
	%{subst_enable dbus} \
	%{subst_enable tk} \
	%{subst_enable tcl} \
	%{subst_enable consoleui} \
	%{subst_enable meanwhile} \
	%{subst_enable idn} \
	%{subst_enable farstream} \
	%{subst_enable vv} \
	%{subst_enable gstreamer} \
	%{subst_enable sm} \
	%{subst_enable screensaver} \
	%{subst_enable gestures} \
	%{subst_enable gtkspell} \
	%{subst_enable devhelp} \
%if_disabled gstreamer
	--disable-gstreamer-interfaces \
%endif
%if_enabled gnutls
	--enable-gnutls=yes \
%else
	--enable-gnutls=no \
%endif
%if_enabled cyrus_sasl
	--enable-cyrus-sasl \
%else
	--disable-cyrus-sasl \
%endif
%if_enabled nss
	--with-nss-includes=%_includedir/nss \
	--with-nspr-includes=%_includedir/nspr \
	--with-nspr-libs=%_libdir \
	--with-nss-libs=%_libdir \
	--enable-nss=yes \
%else
	--enable-nss=no \
%endif
%if_enabled perl
	--with-perl-lib=vendor \
%endif
	--with-python3=%__python3 \
	--with-system-ssl-certs=%_datadir/ca-certificates \
	--with-extraversion=%release

%make_build

%install
%make DESTDIR=%buildroot install

# install ALTLinux pidgin default prefs.xml
mkdir -p %buildroot%_sysconfdir/purple
install -m 644 prefs.xml %buildroot%_sysconfdir/purple/prefs.xml
sed -i 's|/usr/lib|%_libdir|' %buildroot%_sysconfdir/purple/prefs.xml

find %buildroot%_libdir -name \*.la -delete
# remove non-plugin unrequired library symlinks
rm -f %buildroot%_libdir/purple-2/liboscar.so
rm -f %buildroot%_libdir/purple-2/libymsg.so

%find_lang --with-gnome %name

%post
%gconf2_install purple

%preun
if [ $1 = 0 ]; then
    %gconf2_uninstall purple
fi

%files -f %name.lang
%doc AUTHORS COPYRIGHT INSTALL NEWS README doc/*.txt
%config %_sysconfdir/gconf/schemas/*
%_bindir/%name
%_libdir/%name
%_desktopdir/%name.desktop
%_datadir/metainfo/*.appdata.xml
%_pixmapsdir/%name
%_iconsdir/hicolor/*/apps/*
%_man1dir/%name.*
%if_enabled perl
%perl_vendor_archlib/Pidgin.pm
%dir %perl_vendor_autolib/Pidgin
%perl_vendor_autolib/Pidgin/*
%perl_vendor_man3dir/Pidgin*
%endif
%if_enabled gevolution
%exclude %_libdir/%name/gevolution.so
%endif
%if_enabled relnot
%exclude %_libdir/%name/relnot.so
%endif

%if_enabled relnot
%files -n %name-relnot
%_libdir/%name/relnot.so
%endif

%files -n libpurple
%dir %_sysconfdir/purple
%config(noreplace) %_sysconfdir/purple/*
%_libdir/libpurple.so.*
%_libdir/purple-2
%_datadir/sounds/purple
%if_enabled tcl
%exclude %_libdir/purple-2/tcl.so
%endif
%if_enabled mono
%exclude %_libdir/purple-2/mono.so
%exclude %_libdir/purple-2/*.dll
%endif
%if_enabled perl
%exclude %_libdir/purple-2/perl.so
%endif

%if_enabled dbus
%files -n libpurple-dbus
%_bindir/purple-client-example
%_bindir/purple-remote
%_bindir/purple-send
%_bindir/purple-send-async
%_bindir/purple-url-handler

%files -n libpurple-client
%_libdir/libpurple-client.so.*
%endif

%if_enabled gevolution
%files -n %name-gevolution
%_libdir/%name/gevolution.so
%endif

%if_enabled mono
%files -n libpurple-mono
%_libdir/purple-2/mono.so
%_libdir/purple-2/*.dll
%endif

%if_enabled perl
%files -n libpurple-perl
%_libdir/purple-2/perl.so
%perl_vendor_archlib/Purple.pm
%dir %perl_vendor_autolib/Purple
%perl_vendor_autolib/Purple/*
%perl_vendor_man3dir/Purple*
%endif

%if_enabled tcl
%files -n libpurple-tcl
%_libdir/purple-2/tcl.so
%endif

%files devel
%_includedir/%name
%_pkgconfigdir/%name.pc

%files -n libpurple-devel
%doc ChangeLog.API HACKING PLUGIN_HOWTO libpurple/purple-notifications-example
%_includedir/libpurple
%_libdir/libpurple.so
%if_enabled dbus
%_libdir/libpurple-client.so
%endif
%_pkgconfigdir/purple.pc
%_datadir/aclocal/purple.m4

%if_enabled consoleui
%files -n finch
%_man1dir/finch.*
%_bindir/finch
%_libdir/finch

%files -n finch-devel
%_includedir/finch
%_pkgconfigdir/finch.pc
%endif

%changelog
