%define		php_extension	pdo_mysql

Name:	 	php%_php_suffix-%php_extension
Version:	%php_version
Release:	%php_release

Summary:	MySQL driver for PHP Data Objects Interface

Group:		System/Servers
License:	PHP-3.01
URL:		https://www.php.net/manual/en/ref.pdo-mysql.php

#Source0:	standart PHP module
Source1:	php-%php_extension.ini
Source2:	php-%php_extension-params.sh


BuildRequires(pre): rpm-build-php8.1-version
BuildRequires: gcc-c++
BuildRequires: re2c
BuildRequires: php-devel = %php_version
BuildRequires: php%_php_suffix-pdo-devel = %php_version
Requires: php%_php_suffix-mysqlnd
Conflicts: php%_php_suffix-mysqlnd-%php_extension

PreReq: php%_php_suffix-pdo = %php_version
Provides: php-pdo-driver


%description
PHP PDO extension provides a uniform data access interface, supporting advanced
features such as prepared statements and bound parameters. 
This package contains a MySQL driver for PDO.

%prep
%setup -T -c
cp -pr -- %php_extsrcdir/%php_extension/* .

# Fix path to pdo*.h
subst 's@php/ext@php/%_php_version/ext@g' config.m4

%build
phpize

BUILD_HAVE=`echo %php_extension | tr '[:lower:]-' '[:upper:]_'`
%add_optflags -fPIC -L%_libdir
export LDFLAGS=-lphp-%_php_version

# Fix for config.m4 in %%prep would't work for some reason
subst 's@php/ext@php/%_php_version/ext@g' configure

%configure \
	--with-%php_extension \
	--with-libdir=%_lib \
	--with-pdo-mysql=mysqlnd \
	#

%php_make RE2C=/usr/bin/re2c

%install
%php_make_install
install -D -m 644 -- %SOURCE1 %buildroot/%php_extconf/%php_extension/config
install -D -m 644 -- %SOURCE2 %buildroot/%php_extconf/%php_extension/params

%files
%php_extconf/%php_extension
%php_extdir/*
%doc CREDITS

%post
%php_extension_postin

%preun
%php_extension_preun

%changelog
