%define _unpackaged_files_terminate_build 1
%def_enable snapshot

%define ver_major 0.51
%define beta %nil
%define gmobile_ver 0.4.0
%define rdn_name mobi.phosh.MobileSettings

%def_disable embed_gmobile
# Linux dmabuf support unavailable
%def_disable check

%define gvc_ver 5f9768a

Name: phosh-mobile-settings
Version: %ver_major.0
Release: alt1%beta

Summary: Mobile Settings App for phosh and related components
Group: Graphical desktop/GNOME
License: GPL-3.0-or-later
Url: https://gitlab.gnome.org/World/Phosh/phosh-mobile-settings

Vcs: https://gitlab.gnome.org/World/Phosh/phosh-mobile-settings

%if_disabled snapshot
Source: https://gitlab.gnome.org/World/Phosh/phosh-mobile-settings/-/archive/v%version/%name-v%version%beta.tar.gz
%else
Source: %name-%version%beta.tar
%endif
# https://gitlab.gnome.org/GNOME/libgnome-volume-control.git
Source10: gvc-%gvc_ver.tar
%{?_enable_embed_gmobile:Source11: gmobile-%gmobile_ver.tar}

%define phoc_ver %ver_major
%define phosh_ver %ver_major
%define phosh_settings_ver 0.40
%define desktop_ver 44

Requires: dconf feedbackd lm_sensors3
# and ModemManager 1.25.1
Requires: cellbroadcastd

BuildRequires(pre): rpm-macros-meson
BuildRequires: gcc-c++ meson
BuildRequires: /usr/bin/appstreamcli desktop-file-utils
BuildRequires: pkgconfig(gio-2.0) >= 2.84
BuildRequires: pkgconfig(gtk4) >= 4.12.5
BuildRequires: pkgconfig(gtk4-wayland) >= 4.4
BuildRequires: pkgconfig(libadwaita-1) >= 1.5
BuildRequires: pkgconfig(wayland-client) >= 1.14
BuildRequires: pkgconfig(wayland-protocols) >= 1.12
BuildRequires: pkgconfig(gsound)
BuildRequires: libsensors3-devel
BuildRequires: pkgconfig(phosh-plugins)
BuildRequires: pkgconfig(phosh-settings) >= %phosh_settings_ver
BuildRequires: pkgconfig(gnome-desktop-4) >= %desktop_ver
BuildRequires: pkgconfig(json-glib-1.0)
BuildRequires: pkgconfig(libfeedback-0.0)
BuildRequires: pkgconfig(libportal-gtk4)
# since 0.49
BuildRequires: pkgconfig(libcellbroadcast-0.0)
# since 0.50
BuildRequires: pkgconfig(yaml-0.1)
# for gvc
BuildRequires: pkgconfig(libpulse)
%if_enabled embed_gmobile
BuildRequires: pkgconfig(json-glib-1.0)
BuildRequires: gobject-introspection-devel}
%else
BuildRequires: pkgconfig(gmobile) >= %gmobile_ver
%endif
%{?_enable_check:BuildRequires: xvfb-run phoc >= %phoc_ver phosh /usr/bin/Xwayland}

%description
Mobile Settings App for phosh and related components.

%prep
%setup -n %name-%{?_disable_snapshot:v}%version%beta -a10 %{?_enable_embed_gmobile:-a11
mv gmobile-%gmobile_ver subprojects/gmobile}
mv gvc-%gvc_ver subprojects/gvc

%build
%meson
%meson_build

%install
%meson_install
%{?_enable_embed_gmobile:rm %buildroot%_libdir/libgmobile.*
rm %buildroot%_pkgconfigdir/gmobile.pc}

%find_lang %name

%check
xvfb-run %__meson_test

%files -f %name.lang
%_bindir/%name
%dir %_libdir/%name
%dir %_libdir/%name/plugins
%_libdir/%name/plugins/libms-plugin-librem5.so
%_desktopdir/%rdn_name.desktop
%_datadir/dbus-1/services/%rdn_name.service
%_datadir/glib-2.0/schemas/%rdn_name.gschema.xml
%_datadir/icons/hicolor/scalable/apps/%rdn_name.svg
%_datadir/icons/hicolor/symbolic/apps/%rdn_name-symbolic.svg
%_datadir/metainfo/%rdn_name.metainfo.xml
%doc README* NEWS


%changelog
