%define _unpackaged_files_terminate_build 1

Name:       pgbouncer
Version:    1.25.0
Release:    alt1
Summary:    Lightweight connection pooler for PostgreSQL
License:    ISC
Group:      Databases
Url:        https://github.com/pgbouncer/pgbouncer
Source:     %name-%version.tar
Source1:    pgbouncer.init
Source2:    pgbouncer.ini
Source3:    users.txt
Source4:    pgbouncer.tmpfiles
Source5:    pgbouncer.service
Source6:    pgbouncer.logrotate
Source7:    pgbouncer.pam
Source8:    pgbouncer.sysconfig

Patch0:     pgbouncer-1.25.0-Fix-build-on-i586.patch

BuildRequires(pre): rpm-build-python3
BuildRequires: libssl-devel
BuildRequires: pkgconfig(libevent)
BuildRequires: pkgconfig(libcares) >= 1.9.0
BuildRequires: libpam-devel
BuildRequires: libsystemd-devel
BuildRequires: libldap-devel
%ifnarch %e2k
BuildRequires: pandoc
%endif
# That was a pkg with an ugly temporary name:
Obsoletes: pgbouncer17 < %EVR

%description
Several levels of brutality when rotating connections:

Session pooling - Most polite method. When client connects, a server
connection will be assigned to it for the whole duration it stays
connected. When client disconnects, the server connection will be put
back into pool.

Transaction pooling - Server connection is assigned to client only
during a transaction. When PgBouncer notices that transaction is over,
the server will be put back into pool. This is a hack as it breaks
application expectations of backend connection. You can use it only
when application cooperates with such usage by not using features that
can break. See the table below for breaking features.

Statement pooling - Most aggressive method. This is transaction
pooling with a twist - multi-statement transactions are disallowed.
This is meant to enforce "autocommit" mode on client, mostly targeted
for PL/Proxy.

%prep
%setup -q
%patch0 -p1

%build
export PYTHON=%__python3
touch lib/mk/install-sh
./autogen.sh
%configure \
    --with-systemd \
    --with-pam \
    --with-ldap \
    --with-root-ca-file=/etc/pki/tls/certs/ca-bundle.crt

%ifarch %e2k
sed -i 's,\$(PANDOC).*,touch $@,' doc/Makefile
%endif

%make_build

%install
%makeinstall_std

mkdir -p %buildroot{%_sysconfdir,%_logdir}/%name
mkdir -p %buildroot{%_logrotatedir,%_unitdir,%_initdir,%_tmpfilesdir}

install -p -m755 %SOURCE1 %buildroot%_initdir/%name
install -p -m640 %SOURCE2 %buildroot%_sysconfdir/%name/%name.ini
install -p -m640 %SOURCE3 %buildroot%_sysconfdir/%name/users.txt
install -p -m644 %SOURCE4 %buildroot%_tmpfilesdir/%name.conf
install -p -m644 %SOURCE5 %buildroot%_unitdir/%name.service
install -p -m644 %SOURCE6 %buildroot%_logrotatedir/%name
install -p -m644 -D %SOURCE7 %buildroot%_sysconfdir/pam.d/%name
install -p -m644 -D %SOURCE8 %buildroot%_sysconfdir/sysconfig/%name

# Let RPM pick up docs in the files section
rm -fr %buildroot%_defaultdocdir

%pre
groupadd -r -f %name 2>/dev/null ||:
useradd  -r -g %name -s /sbin/nologin -c "PgBouncer Server" -M -d /run/%name %name 2>/dev/null ||:

%post
%post_service %name

%preun
%preun_service %name

%files
%doc NEWS.md README.md doc/*.md
%_bindir/%name
%ifnarch %e2k
%_man1dir/*
%_man5dir/*
%endif
%attr(750,root,%name) %dir %_sysconfdir/%name
%config(noreplace) %attr(640,root,%name) %_sysconfdir/%name/%name.ini
%config(noreplace) %attr(640,root,%name) %_sysconfdir/%name/users.txt
%config(noreplace) %_sysconfdir/pam.d/%name
%config(noreplace) %_logrotatedir/%name
%config(noreplace) %_sysconfdir/sysconfig/%name
%_tmpfilesdir/%name.conf
%_initdir/%name
%_unitdir/%name.service
%attr(1770,root,%name) %dir %_logdir/%name

%changelog
